#ifndef _MDC_IMAGE_H_
#define _MDC_IMAGE_H_

#include "mdc_figure.h"
#include "mdc_draw_util.h"

BEGIN_MDC_DECLS

class MYSQLCANVAS_PUBLIC_FUNC ImageFigure : public Figure {
public:  
  ImageFigure(Layer *layer);
  virtual ~ImageFigure();

  virtual void draw_contents(CairoCtx *cr);

  bool set_image(cairo_surface_t *surface);
  bool set_image(const std::string &path);
  Size get_image_size() const;

  cairo_surface_t *get_image() { return _image; }

protected:
  cairo_surface_t *_image;

  virtual Size calc_min_size();
};


END_MDC_DECLS


#endif /* _MDC_IMAGE_H_ */
