/*
 *  mdc_line_segment_handle.cpp
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/1.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#include "stdafx.h"

#include "mdc_line_segment_handle.h"

using namespace mdc;

LineSegmentHandle::LineSegmentHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos, bool vertical)
: ItemHandle(ilayer, item, pos)
{
  set_color(Color(0.4,0.7,1));
  _vertical= vertical;
}


LineSegmentHandle::~LineSegmentHandle()
{
}


void LineSegmentHandle::set_vertical(bool flag)
{
  _vertical= flag;
}


mdc::Rect LineSegmentHandle::get_bounds() const
{
  Rect r;
  Point pos(_pos.round());
  
  if (_vertical)
  {
    r.pos.x= pos.x - 2.5;
    r.pos.y= pos.y - 6.5;
    r.size.width= 5;
    r.size.height= 12;
  }
  else
  {
    r.pos.x= pos.x - 6.5;
    r.pos.y= pos.y - 2.5;
    r.size.width= 12;
    r.size.height= 5;
  }

  return r;
}
