/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include <mforms/code_editor.h>
#include <mforms/mforms.h>

using namespace mforms;

//--------------------------------------------------------------------------------------------------

CodeEditor::CodeEditor()
  : _updating(false)
{
  _code_editor_impl= &ControlFactory::get_instance()->_code_editor_impl;

  _code_editor_impl->create(this);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_text(const std::string& text)
{
  _updating = true;
  _code_editor_impl->set_text(this, text);
  _updating = false;
}

//--------------------------------------------------------------------------------------------------

const std::string CodeEditor::get_text(bool selection_only)
{
  return _code_editor_impl->get_text(this, selection_only);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_selection(int start, int length)
{
  _code_editor_impl->set_selection(this, start, length);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::get_selection(int &start, int &length)
{
  _code_editor_impl->get_selection(this, start, length);
}

//--------------------------------------------------------------------------------------------------

bool CodeEditor::get_range_of_line(int line, int &start, int &length)
{
  return _code_editor_impl->get_range_of_line(this, line, start, length);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_language(SyntaxHighlighterLanguage language)
{
  _code_editor_impl->set_language(this, language);
}

//--------------------------------------------------------------------------------------------------

void mforms::CodeEditor::set_read_only(bool flag)
{
  _code_editor_impl->set_read_only(this, flag);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::show_markup(LineMarkup markup, int line)
{
  _code_editor_impl->show_markup(this, markup, line);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::remove_markup(LineMarkup markup, int line)
{
  _code_editor_impl->remove_markup(this, markup, line);
}

//--------------------------------------------------------------------------------------------------

int mforms::CodeEditor::line_count()
{
  return _code_editor_impl->line_count(this);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_font(const std::string& fontDescription)
{
  _code_editor_impl->set_font(this, fontDescription);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::text_changed(int line, int linesAdded)
{
  if (!_updating)
    _signal_changed.emit(line, linesAdded);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::gutter_clicked(int margin, int line, mforms::ModifierKey modifiers)
{
  _signal_gutter_clicked.emit(margin, line, modifiers);
}

//--------------------------------------------------------------------------------------------------
