/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"
#include <stdio.h>
#include <mforms/mforms.h>


using namespace mforms;

FileChooser::FileChooser(FileChooserType type, bool show_hidden)
{
  _filechooser_impl= &ControlFactory::get_instance()->_filechooser_impl;

  _filechooser_impl->create(this, type, show_hidden);
}


void FileChooser::set_title(const std::string &title)
{
  _filechooser_impl->set_title(this, title);
}

bool FileChooser::run_modal()
{
  return _filechooser_impl->run_modal(this);
}

void FileChooser::set_directory(const std::string &path)
{
  _filechooser_impl->set_directory(this, path);
}

std::string FileChooser::get_path()
{
  return _filechooser_impl->get_path(this);
}

std::string FileChooser::get_directory()
{
  return _filechooser_impl->get_directory(this);
}

void FileChooser::set_extensions(const std::string &extensions, const std::string &default_extension)
{
  _filechooser_impl->set_extensions(this, extensions, default_extension);
}


std::vector<std::pair<std::string, std::string> > FileChooser::split_extensions(const std::string &extensions)
{
  std::vector<std::pair<std::string, std::string> > exts;
  std::string::size_type s, e;
  std::string label, pattern;
  std::string part;
  
  s= 0;
  do
  {
    e= extensions.find('|', s);
    if (e == std::string::npos)
    {
      printf("ERROR: extension list %s contains errors\n", extensions.c_str());
      return exts;
    }
    label= extensions.substr(s, e);
    s= e+1;
    e= extensions.find('|', s);
    if (e == std::string::npos)
      pattern= extensions.substr(s);
    else
    {
      pattern= extensions.substr(s, e);
      s= e+1;
    }
    
    if (pattern[0] != '*')
    {
      printf("ERROR: extension list %s contains errors (file extension pattern should start with *)\n",
             extensions.c_str());
      continue;
    }
    exts.push_back(std::pair<std::string,std::string>(label, pattern));
  } while (e != std::string::npos);
  
  return exts;
}
