/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _LF_BOX_H_
#define _LF_BOX_H_

#include "mforms/button.h"

#include "lf_view.h"


namespace mforms {
namespace gtk {

class BoxImpl : public ViewImpl
{  
protected:
  Gtk::Box *_box;
  
  virtual Gtk::Widget *get_outer() const { return _box; }

  BoxImpl(::mforms::Box *self, bool horiz)
    : ViewImpl(self)
  {
    if (horiz)
      _box= new Gtk::HBox();
    else
      _box= new Gtk::VBox();
  }

  static bool create(::mforms::Box *self, bool horiz)
  {
    return new BoxImpl(self, horiz);
  }

  static void add(Box *self, View *child, bool expand, bool fill)
  {
    BoxImpl *box= self->get_data<BoxImpl>();

    box->_box->pack_start(*child->get_data<ViewImpl>()->get_outer(), expand, fill);
    child->show();
  }

  static void add_end(Box *self, View *child, bool expand, bool fill)
  {
    BoxImpl *box= self->get_data<BoxImpl>();

    box->_box->pack_end(*child->get_data<ViewImpl>()->get_outer(), expand, fill);
    child->show();
  }

  static void remove(Box *self, View *child)
  {
    BoxImpl *box= self->get_data<BoxImpl>();

    box->_box->remove(*child->get_data<ViewImpl>()->get_outer());
  }

  static void set_homogeneous(Box *self, bool flag)
  {
    BoxImpl *box= self->get_data<BoxImpl>();
    
    box->_box->set_homogeneous(flag);
  }

  static void set_spacing(Box *self, int spc)
  {
    BoxImpl *box= self->get_data<BoxImpl>();
    
    box->_box->set_spacing(spc);
  }
  
  static void set_padding(Box *self, int pad)
  {
    BoxImpl *box= self->get_data<BoxImpl>();
    
    box->_box->set_border_width(pad);
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_box_impl.create= &BoxImpl::create;
    f->_box_impl.add= &BoxImpl::add;
    f->_box_impl.add_end= &BoxImpl::add_end;
    f->_box_impl.remove= &BoxImpl::remove;
    f->_box_impl.set_homogeneous= &BoxImpl::set_homogeneous;
    f->_box_impl.set_spacing= &BoxImpl::set_spacing;
    f->_box_impl.set_padding= &BoxImpl::set_padding;
  }
  
  virtual ~BoxImpl()
  {
    delete _box;
  }
};

}
}


#endif /* _LF_BOX_H_ */
