/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MFORMS_MENU_H_
#define _MFORMS_MENU_H_

#include <mforms/base.h>
#include <sigc++/sigc++.h>

namespace mforms {
  class Menu;
 
#ifndef DOXYGEN_SHOULD_SKIP_THIS 
#ifndef SWIG
  struct MFORMS_EXPORT MenuImplPtrs
  {
    bool (__stdcall *create)(Menu *self);
    
    void (__stdcall *remove_item)(Menu *self, int i);
    int (__stdcall *add_item)(Menu *self, const std::string &caption, const std::string &action);
    int (__stdcall *add_separator)(Menu *self);
    int (__stdcall *add_submenu)(Menu *self, const std::string &caption, Menu *submenu);
    
    void (__stdcall *set_item_enabled)(Menu *self, int i, bool flag);
    
    void (__stdcall *popup_at)(Menu *self, Object *control, int x, int y);
  };
#endif
#endif
  
  class MFORMS_EXPORT Menu : public Object, public sigc::trackable
  {
  private:
    MenuImplPtrs *_menu_impl;
    sigc::slot<void, const std::string&> _action_handler;
    sigc::signal<void> _on_will_show;
  public:
    Menu();

    void remove_item(int i);
    int add_item(const std::string &caption, const std::string &action);
    int add_separator();
    int add_submenu(const std::string &caption, Menu *submenu);

    void set_item_enabled(int i, bool flag);

    void set_handler(const sigc::slot<void, const std::string&> &action_handler);

    void popup_at(Object *control, int x, int y);

    void handle_action(const std::string &action);    
    
    sigc::signal<void> signal_will_show() { return _on_will_show; }
  };
};

#endif
