/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_CODE_EDITOR_H_
#define _WF_CODE_EDITOR_H_

/**
 * Implements an mforms wrapper class for the Scintilla editor.
 *
 * @ingroup mforms
 */

#include "mforms/code_editor.h"
#include "wf_view.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class CodeEditorImpl : public ViewImpl
    {
    protected:
      CodeEditorImpl(mforms::CodeEditor *self);

      static bool create(mforms::CodeEditor* self);
      static void set_text(mforms::CodeEditor * self, const std::string& text);
      static const std::string get_text(mforms::CodeEditor* self, bool selection_only);
      static void get_selection(mforms::CodeEditor* self, int &start, int &length);
      static void set_selection(mforms::CodeEditor* self, int start, int length);
      static bool get_range_of_line(mforms::CodeEditor* self, int line, int &start, int &length);
      static void set_language(mforms::CodeEditor* self, mforms::SyntaxHighlighterLanguage language);
      static void set_read_only(mforms::CodeEditor* self, bool flag);
      static void show_markup(mforms::CodeEditor* self, mforms::LineMarkup markup, int line);
      static void remove_markup(mforms::CodeEditor* self, mforms::LineMarkup markup, int line);
      static int line_count(mforms::CodeEditor* self);
      static void set_font(mforms::CodeEditor* self, const std::string& fontDescription);

      void text_changed(Object^ sender, ScintillaNet::TextModifiedEventArgs^ args);
      void margin_clicked(Object^ sender, ScintillaNet::MarginClickEventArgs^ args);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::CodeEditor*, mgr, f->_code_editor_impl, CodeEditorImpl, create);
        DEF_CALLBACK2(void, mforms::CodeEditor*, const std::string&, mgr, f->_code_editor_impl, CodeEditorImpl, set_text);
        DEF_CALLBACK2(const std::string, mforms::CodeEditor*, bool, mgr, f->_code_editor_impl, CodeEditorImpl, get_text);
        DEF_CALLBACK3(void, mforms::CodeEditor*, int&, int&, mgr, f->_code_editor_impl, CodeEditorImpl, get_selection);
        DEF_CALLBACK3(void, mforms::CodeEditor*, int, int, mgr, f->_code_editor_impl, CodeEditorImpl, set_selection);
        DEF_CALLBACK4(bool, mforms::CodeEditor*, int, int&, int&, mgr, f->_code_editor_impl, CodeEditorImpl, get_range_of_line);
        DEF_CALLBACK2(void, mforms::CodeEditor*, mforms::SyntaxHighlighterLanguage, mgr, f->_code_editor_impl, CodeEditorImpl, set_language);
        DEF_CALLBACK2(void, mforms::CodeEditor*, bool, mgr, f->_code_editor_impl, CodeEditorImpl, set_read_only);
        DEF_CALLBACK3(void, mforms::CodeEditor*, mforms::LineMarkup, int, mgr, f->_code_editor_impl, CodeEditorImpl, show_markup);
        DEF_CALLBACK3(void, mforms::CodeEditor*, mforms::LineMarkup, int, mgr, f->_code_editor_impl, CodeEditorImpl, remove_markup);
        DEF_CALLBACK1(int, mforms::CodeEditor*, mgr, f->_code_editor_impl, CodeEditorImpl, line_count);
        DEF_CALLBACK2(void, mforms::CodeEditor*, const std::string&, mgr, f->_code_editor_impl, CodeEditorImpl, set_font);
      }
    };

  };
};

#endif // _WF_CODE_EDITOR_H_
