#ifndef _MODULE_DB_MYSQL_SHARED_CODE_H_
#define _MODULE_DB_MYSQL_SHARED_CODE_H_

#include "string_utilities.h"

static std::string get_qualified_schema_object_name(const GrtNamedObjectRef object)
{
  if(object.is_instance("db.Catalog"))
    return std::string("`")
    .append(object->name().c_str()).append("`");
  else if(object.is_instance("db.Trigger"))
    return std::string("`")
    .append(object->owner()->owner()->name().c_str()).append("`.`")
    .append(object->name().c_str()).append("`");
  else if(object.is_instance("db.Index"))
    return std::string("`")
    .append(object->owner()->owner()->name().c_str()).append("`.`")
    .append(object->owner()->name().c_str()).append("`.`")
    .append(object->name().c_str()).append("`");
  else if(object.is_instance("db.User"))
    return std::string("`").append(object->name()).append("`");

  return std::string("`")
    .append(object->owner()->name().c_str()).append("`.`")
    .append(object->name().c_str()).append("`");
}

static std::string get_object_old_name(GrtNamedObjectRef object)
{
  if(strlen(object->oldName().c_str()) > 0)
    return std::string(object->oldName().c_str());
  return std::string(object->name().c_str());
}

static std::string get_object_old_name(GrtObjectRef object)
{
  if(GrtNamedObjectRef::can_wrap(object))
    return get_object_old_name(GrtNamedObjectRef::cast_from(object));
  return std::string(object->name().c_str());
}

static std::string get_qualified_schema_object_old_name(GrtNamedObjectRef object)
{
  if(object.is_instance("db.Catalog"))
    return std::string("`")
    .append(get_object_old_name(object)).append("`");
  else if(object.is_instance("db.Trigger"))
    return std::string("`")
    .append(get_object_old_name(object->owner()->owner())).append("`.`")
    .append(get_object_old_name(object)).append("`");
  else if(object.is_instance("db.Index"))
    return std::string("`")
    .append(get_object_old_name(object->owner()->owner())).append("`.`")
    .append(get_object_old_name(object->owner())).append("`.`")
    .append(get_object_old_name(object)).append("`");
  else if(object.is_instance("db.User"))
    return std::string("`").append(get_object_old_name(object)).append("`");

  return std::string("`")
    .append(get_object_old_name(object->owner())).append("`.`")
    .append(get_object_old_name(object)).append("`");
}

static std::string get_full_object_name_for_key(GrtNamedObjectRef object)
{
  const std::string result = std::string(object.class_name())
    .append("::").append(get_qualified_schema_object_old_name(object).append("::").append(object->name()));
  return base::toupper(result);
}

static std::string get_old_object_name_for_key(GrtNamedObjectRef object)
{
  std::string old_name = object->oldName().empty()?object->name():object->oldName();
  const std::string result = std::string(object.class_name())
    .append("::").append(get_qualified_schema_object_old_name(object).append("::").append(old_name));
  return base::toupper(result);
}

#endif
