#ifndef __WB_MYSQL_TABLE_EDITOR_INDEX_PAGE_H__
#define __WB_MYSQL_TABLE_EDITOR_INDEX_PAGE_H__

#include "grt/tree_model.h"

class MySQLTableEditorBE;
class MGGladeXML;
class ListModelWrapper;
class DbMySQLTableEditor;

//==============================================================================
//
//==============================================================================
class DbMySQLTableEditorIndexPage
{
  public:
    DbMySQLTableEditorIndexPage(DbMySQLTableEditor *owner, MySQLTableEditorBE* be, MGGladeXML* xml);

    void refresh();

    void switch_be(MySQLTableEditorBE* be);  
  private:
    void cell_editing_started(Gtk::CellEditable *cell, const Glib::ustring &path);

    //! index_cursor_changed is called when current item in the index treeview is changed
    void index_cursor_changed();
    //! update_index_details fetches index details for selected index. selected index is stored in _index_node
    void update_index_details();
    //! get_value is a source of data for treeview columns: set/unset column for index, order of index
    //! get_value is connected to a model wrapper in update_index_details
    void get_value(const Gtk::TreeModel::iterator& iter, int column, GType type, Glib::ValueBase& value);
    //! set_value is a model wrapper setter of data for treeview columns: set/unset column for index, order of index
    //! set_value is connected to a model wrapper in update_index_details
    void set_value(const Gtk::TreeModel::iterator& iter, int column, GType type, const Glib::ValueBase& value);

    void update_index_storage_type_in_be();

    void set_index_key_block_size(const std::string& value);
    void set_index_parser(const std::string& value);
    void set_index_comment(const std::string& value);

    Glib::RefPtr<Gtk::ListStore>              recreate_order_model();

    DbMySQLTableEditor                       *_owner;
    MySQLTableEditorBE                       *_be;
    MGGladeXML                               *_xml;

    Gtk::TreeView                            *_indexes_tv;
    Glib::RefPtr<ListModelWrapper>            _indexes_model;
    Glib::RefPtr<ListModelWrapper>            _indexes_columns_model;
    Glib::RefPtr<Gtk::ListStore>              _sort_order_model;
    Glib::RefPtr<Gtk::ListStore>              _order_model; //!< for index columns
    Gtk::ComboBoxText                        *_index_storage_combo;
    sigc::connection                          _index_storage_combo_conn;

    ::bec::NodeId                             _index_node;
};

#endif
