
/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 MacTableEditorInformationSource
 
 @abstract
 The purpose of this class is to insulate the C++ data structures needed by the MySQL Table Editor.
 
 @ingroup
 MySQL Table Editor
 */


#import "MacTableEditorInformationSource.h"



@implementation MacTableEditorInformationSource



- (void) refresh;
{
  [self listModel]->refresh();
}



- (NSInteger) numberOfRows;
{
  return [self numberOfRowsInTableView: nil];
}



- (id) objectValueForValueIndex: (NSInteger) valueIndex
                            row: (NSInteger) rowIndex;
{
  NSString* val = nil;
  
  if ([self listModel] != nil) {
    std::string value;
    int didFine = [self listModel]->get_field(rowIndex, valueIndex, value);
    if (didFine == 1)
      val = [NSString stringWithUTF8String: value.c_str()];
    else
      val = @"error";
  }
  
  return val;
}



- (void) setStringValue: (NSString*) value
          forValueIndex: (int) valueIndex
                    row: (NSInteger) rowIndex;
{
  if ([self listModel] != nil) {
    [self listModel]->set_field(rowIndex, valueIndex, [value UTF8String]);
  }

  [self listModel]->refresh();
}



- (void) setIntValue: (NSInteger) value
       forValueIndex: (int) valueIndex
                 row: (NSInteger) rowIndex;
{
  if ([self listModel] != nil) {
    [self listModel]->set_field(rowIndex, valueIndex, value);
  }
  
  [self listModel]->refresh();
}



@end


