#ifndef __MYSQL_SCHEMA_EDITOR_H__
#define __MYSQL_SCHEMA_EDITOR_H__

#include "mysql_schema_editor.h"
#include "GrtTemplates.h"
#include "grtdb/db_object_helpers.h"

#ifdef _MSC_VER
using namespace MySQL::Grt;
#endif

namespace MySQL {
namespace Grt {
namespace Db {

public ref class MySQLSchemaEditorBE : public SchemaEditorBE
{
protected:
  MySQLSchemaEditorBE(::MySQLSchemaEditorBE *inn)
    : SchemaEditorBE(inn)
  {}

public:
  MySQLSchemaEditorBE::MySQLSchemaEditorBE(GrtManager^ grtm, GrtValue^ arglist)
  : SchemaEditorBE(
      new ::MySQLSchemaEditorBE(grtm->get_unmanaged_object(), 
      db_mysql_SchemaRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)),
      get_rdbms_for_db_object(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
        )
      )
  {}

  ::MySQLSchemaEditorBE *get_unmanaged_object()
  { return static_cast<::MySQLSchemaEditorBE *>(inner); }

  bool is_new_object() { return get_unmanaged_object()->get_schema()->oldName() == ""; }

  void refactor_catalog_upon_schema_rename(String^ old_name, String^ new_name)
  { get_unmanaged_object()->refactor_catalog_upon_schema_rename(NativeToCppString(old_name), NativeToCppString(new_name)); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __MYSQL_SCHEMA_EDITOR_H__
