/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "MySQLTableEditorBE.h"
#include "grtdb/db_object_helpers.h"

namespace MySQL {
namespace GUI {
namespace Workbench {
namespace Plugins {

MySQLTableColumnsListBE::MySQLTableColumnsListBE(::MySQLTableColumnsListBE *inn)
  : TableColumnsListBE(inn)
{}

#pragma unmanaged

// TODO: this function is duplicated in ViewEditorBE.cpp wrapper, avoid duplication

//static inline db_mgmt_RdbmsRef get_rdbms_for_db_object(const ::grt::ValueRef &object)
//{
//  GrtObjectRef parent= GrtObjectRef::cast_from(object);
//  while (parent.is_valid() && !parent.is_instance("db.Catalog"))
//    parent= parent->owner();
//  return workbench_physical_ModelRef::cast_from(parent->owner())->rdbms();
//}

#pragma managed

MySQLTableEditorBE::MySQLTableEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
: TableEditorBE(
      new ::MySQLTableEditorBE(grtm->get_unmanaged_object(), 
      db_mysql_TableRef::cast_from(::grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)),
      get_rdbms_for_db_object(::grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
      )
    )
{
}

MySQLTableColumnsListBE^ MySQLTableEditorBE::get_columns() 
{ return gcnew MySQLTableColumnsListBE(get_unmanaged_object()->get_columns()); }


MySQLTablePartitionTreeBE^ MySQLTableEditorBE::get_partitions()
{
  return gcnew MySQLTablePartitionTreeBE(get_unmanaged_object()->get_partitions());
}


};  // namespace Plugins
};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL
