#ifndef _FETCH_SCHEMA_CONTENTS_PAGE_H_
#define _FETCH_SCHEMA_CONTENTS_PAGE_H_


class FetchSchemaContentsProgressPage : public WizardProgressPage
{
public:
  FetchSchemaContentsProgressPage(WizardForm *form, const char *name= "fetchSchema")
    : WizardProgressPage(form, name)
  {
    set_title(_("Retrieve Object Information"));
    set_short_title(_("Fetch Object Info"));

    add_async_task(_("Retrieve Objects from Selected Schemata"),
                   sigc::mem_fun(this, &FetchSchemaContentsProgressPage::perform_fetch),
                   _("Retrieving object lists from selected schemata..."));

    add_task(_("Check Results"), 
             sigc::mem_fun(this, &FetchSchemaContentsProgressPage::perform_check),
             _("Checking Retrieved data..."));

    end_adding_tasks(true,
                     _("Retrieval Completed Successfully"));
    
    set_status_text("");
  }
  
  
  bool perform_fetch()
  {
    execute_grt_task(sigc::mem_fun(this, &FetchSchemaContentsProgressPage::do_fetch),
                     false);
    return true;
  }
  
  
  bool perform_check()
  {
    _finished= true;

    return true;
  }


  grt::ValueRef do_fetch(grt::GRT *grt)
  {
    grt::StringListRef selection(grt::StringListRef::cast_from(values().get("selectedSchemata")));
    std::vector<std::string> names;

    for (grt::StringListRef::const_iterator iter= selection.begin();
         iter != selection.end(); ++iter)
      names.push_back(*iter);

    // tell the backend about the selection
    _dbplugin->schemata_selection(names, true);

    _dbplugin->load_db_objects(Db_plugin::dbotTable);
    _dbplugin->load_db_objects(Db_plugin::dbotView);
    _dbplugin->load_db_objects(Db_plugin::dbotRoutine);
    _dbplugin->load_db_objects(Db_plugin::dbotTrigger);

    return grt::ValueRef();
  }

  
  virtual void enter(bool advancing)
  {
    if (advancing)
    {
      _finished= false;
      reset_tasks();
    }
    WizardProgressPage::enter(advancing);
  }
  

  virtual bool allow_next()
  {
    return _finished;
  }


  void set_db_plugin(Db_plugin *dbplugin)
  {
    _dbplugin= dbplugin;
  }
  
private:
  Db_plugin *_dbplugin;
  bool _finished;
};

#endif /* _FETCH_SCHEMA_CONTENTS_PAGE_H_ */
