opts_list = ( ( 'General',
    ( ( 'Networking',
        ( { 'caption': 'enable-named-pipe',
            'description': 'Enable support for named pipes.',
            'name': 'enable-named-pipe',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'port',
            'description': 'Port number to use for connection',
            'name': 'port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-networking',
            'description': "Don't allow connection with TCP/IP",
            'name': 'skip-networking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Directories',
        ( { 'caption': 'datadir',
            'description': 'Path to the database root',
            'name': 'datadir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'basedir',
            'description': 'Path to installation directory',
            'name': 'basedir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'tmpdir',
            'description': 'Path for temporary files',
            'name': 'tmpdir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Memory usage',
        ( { 'caption': 'sort_buffer_size',
            'description': 'Each thread that needs to do a sort allocates a buffer of this size',
            'name': 'sort_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '2097144',
                          'maximum': '4294967295',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '2097144',
                          'maximum': '18446744073709547520',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( 'General',
        ( { 'caption': 'datetime_format',
            'description': 'The DATETIME/TIMESTAMP format (for future)',
            'name': 'datetime_format',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'init-file',
            'description': 'Read SQL commands from this file at startup',
            'name': 'init-file',
            'optype': { 'format': 'init-file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-filesystem',
            'description': 'Set the file system character set',
            'name': 'character-set-filesystem',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 19), (5, 1, 6)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'debug-sync-timeout',
            'description': 'Timeout for Debug Sync synchronization points',
            'name': 'debug-sync-timeout',
            'values': ({ 'type': 'numeric'},),
            'versions': ( ((5, 1, 41), (6, 0, 6)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'console',
            'description': 'Write error output on screen; do not remove the console window on Windows',
            'name': 'console',
            'values': ( { 'off': '0',
                          'on': '1',
                          'platform': 'windows',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'verbose',
            'description': 'Used with --help option for detailed help',
            'name': 'verbose',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-client-handshake',
            'description': "Don't ignore client side character set value sent during handshake",
            'name': 'character-set-client-handshake',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 15),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'standalone',
            'description': 'Instructs the MySQL server not to run as a service',
            'name': 'standalone',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'collation-server',
            'description': 'Set the default collation',
            'name': 'collation-server',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'partition',
            'description': 'Enable (or disable) partitioning support',
            'disabledby': 'skip-partition',
            'name': 'partition',
            'values': ( { 'default': 'on',
                          'off': 'disabledby',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'default-storage-engine',
            'description': 'Set the default storage engine (table type) for tables',
            'name': 'default-storage-engine',
            'values': ( { 'default': 'MyISAM',
                          'outversion': '5.5.4',
                          'type': 'dropdownbox'},
                        { 'default': 'InnoDB',
                          'inversion': '5.5.5',
                          'type': 'dropdownbox'},
                        { 'default': 'MyISAM',
                          'inversion': '6.0.0',
                          'type': 'dropdownbox'}),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'plugin-load',
            'description': 'List of plugins to load at startup',
            'name': 'plugin-load',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 1, 18),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'lower_case_file_system',
            'description': 'This variable describes the case sensitivity of file names on the file system',
            'name': 'lower_case_file_system',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'time_format',
            'description': 'The TIME format (for future)',
            'name': 'time_format',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-sets-dir',
            'description': 'Directory where character sets are',
            'name': 'character-sets-dir',
            'optype': { 'format': 'character-sets-dir=path'},
            'values': ({ 'type': 'dirname'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'default-table-type',
            'deprecated': (5, 0),
            'description': 'This option is a synonym for --default-storage-engine',
            'name': 'default-table-type',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)),
                          ((6, 0, 8),))},
          { 'caption': 'port-open-timeout',
            'description': 'Maximum time in seconds to wait for the port to become free (Default: no wait)',
            'name': 'port-open-timeout',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( ((5, 0, 19), (5, 1, 5)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old',
            'description': 'Cause the server to revert to certain behaviors present in older versions',
            'name': 'old',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((5, 1, 18),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'plugin_dir',
            'description': 'Directory for plugins',
            'name': 'plugin_dir',
            'values': ( { 'default': '/usr/local/mysql/lib/mysql',
                          'type': 'filename'},),
            'versions': ( ((4, 1, 25), (5, 0, 67), (5, 1, 2)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-server',
            'description': 'Set the default character set',
            'name': 'character-set-server',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 3),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-character-set-client-handshake',
            'description': 'Ignore client side character set value sent during handshake',
            'name': 'skip-character-set-client-handshake',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((4, 1, 15), (5, 0, 13)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( 'Advanced',
    ( ( 'Localization',
        ( { 'caption': 'default-time-zone',
            'description': 'Set the default time zone',
            'name': 'default-time-zone',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 3),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'language',
            'deprecated': (5, 5, 0),
            'description': 'Client error messages in given language. May be given as a full path',
            'name': 'language',
            'values': ( { 'default': '/usr/local/mysql/share/mysql/english/',
                          'type': 'dirname'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ())},
          { 'caption': 'default-character-set',
            'deprecated': (5, 0),
            'description': 'Set the default character set',
            'name': 'default-character-set',
            'values': ({ 'type': 'string'},),
            'versions': (((4, 1, 3),), ((4, 1), (5, 0)), ())})),
      ( 'General',
        ( { 'caption': 'open-files-limit',
            'description': 'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()',
            'name': 'open-files-limit',
            'values': ( { 'default': '0',
                          'maximum': '65535',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_frm',
            'description': 'Sync .frm to disk on create. Enabled by default',
            'name': 'sync_frm',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-alter-table',
            'description': 'Use old, nonoptimized alter table',
            'name': 'old-alter-table',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'skip-external-locking',
            'description': 'Skip system (external) locking',
            'name': 'skip-external-locking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'gdb',
            'description': 'Set up signals usable for debugging',
            'name': 'gdb',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'flush',
            'description': 'Flush tables to disk between SQL commands',
            'name': 'flush',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'memlock',
            'description': 'Lock the mysqld process in memory',
            'name': 'memlock',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'tc-heuristic-recover',
            'description': 'Decision to use in heuristic recover process. Possible values are COMMIT or ROLLBACK',
            'name': 'tc-heuristic-recover',
            'values': ( { 'choice': ['COMMIT', 'RECOVER'],
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'default_week_format',
            'description': 'The default week format used by WEEK() functions',
            'name': 'default_week_format',
            'values': ( { 'default': '0',
                          'maximum': '7',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-safemalloc',
            'description': "Don't check for memory overruns during each memory allocation",
            'name': 'skip-safemalloc',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 6),))},
          { 'caption': 'max_sp_recursion_depth',
            'description': 'Maximum stored procedure recursion depth',
            'name': 'max_sp_recursion_depth',
            'values': ( { 'default': '0',
                          'maximum': '255',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 17),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sysdate-is-now',
            'description': 'Nondefault option to alias SYSDATE() to NOW() to make it safe-replicable',
            'name': 'sysdate-is-now',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 20), (5, 1, 8)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-style-user-limits',
            'description': 'Enable old-style user limits (before 5.0.3, user resources were counted per each user+host vs. per account)',
            'name': 'old-style-user-limits',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'flush_time',
            'description': 'A dedicated thread is created to flush all tables at the given interval',
            'name': 'flush_time',
            'values': ( { 'default': '0',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '1800',
                          'minimum': '0',
                          'platform': 'windows',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'use-symbolic-links',
            'deprecated': (5, 0),
            'description': 'Enable symbolic link support. Deprecated option. Use --symbolic-links.',
            'name': 'use-symbolic-links',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((5, 1), (5, 4), (6, 0)), ())},
          { 'caption': 'updatable_views_with_limit',
            'description': 'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key',
            'name': 'updatable_views_with_limit',
            'values': ( { 'default': '1',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-event-scheduler',
            'description': 'Sets the Event Scheduler to OFF.',
            'name': 'skip-event-scheduler',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'low-priority-updates',
            'description': 'INSERT/DELETE/UPDATE has lower priority than selects',
            'name': 'low-priority-updates',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_error_count',
            'description': 'Max number of errors/warnings to store for a statement',
            'name': 'max_error_count',
            'values': ( { 'default': '64',
                          'maximum': '65535',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_prepared_stmt_count',
            'description': 'Maximum number of prepared statements in the server',
            'name': 'max_prepared_stmt_count',
            'optype': { 'inversion': '5.0.21'},
            'values': ( { 'default': '16382',
                          'maximum': '1048576',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 19), (5, 0, 21), (5, 1, 10)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'enable-pstack',
            'deprecated': (5, 1, 54),
            'description': 'Print a symbolic stack trace on failure',
            'name': 'enable-pstack',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 7),))},
          { 'caption': 'skip-stack-trace',
            'description': "Don't print a stack trace on failure",
            'name': 'skip-stack-trace',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Thread specific settings',
        ( { 'caption': 'slow_launch_time',
            'description': 'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented',
            'name': 'slow_launch_time',
            'values': ({ 'default': '2', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_concurrency',
            'description': 'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time',
            'name': 'thread_concurrency',
            'values': ( { 'default': '10',
                          'maximum': '512',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_handling',
            'description': 'The thread-handling model',
            'name': 'thread_handling',
            'values': ( { 'choice': [ 'no-threads',
                                      'one-thread-per-connection'],
                          'outversion': '6.0.3',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'no-threads',
                                      'one-thread-per-connection',
                                      'pool-of-threads'],
                          'inversion': '6.0.4',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 17),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'skip-thread-priority',
            'deprecated': (5, 1, 29),
            'description': "Don't give threads different priorities",
            'name': 'skip-thread-priority',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_pool_size',
            'description': 'The size of the thread pool',
            'name': 'thread_pool_size',
            'values': ( { 'default': '20',
                          'maximum': '16384',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((6, 0, 4),), ((6, 0),), ((6, 0, 14),))},
          { 'caption': 'thread_stack',
            'description': 'The stack size for each thread',
            'name': 'thread_stack',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '196608',
                          'maximum': '4294967295',
                          'minimum': '131072',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '262144',
                          'maximum': '18446744073709547520',
                          'minimum': '131072',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'one-thread',
            'description': 'Only use one thread (for debugging under Linux)',
            'name': 'one-thread',
            'values': (),
            'versions': ( (),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_cache_size',
            'description': 'How many threads we should keep in a cache for reuse',
            'name': 'thread_cache_size',
            'values': ( { 'default': '0',
                          'maximum': '16384',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Insert delayed settings',
        ( { 'caption': 'delayed_insert_timeout',
            'description': 'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating',
            'name': 'delayed_insert_timeout',
            'values': ({ 'default': '300', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delayed_queue_size',
            'description': 'What size queue (in rows) should be allocated for handling INSERT DELAYED',
            'name': 'delayed_queue_size',
            'values': ( { 'bitsize': '32',
                          'default': '1000',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1000',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delayed_insert_limit',
            'description': 'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing',
            'name': 'delayed_insert_limit',
            'values': ( { 'bitsize': '32',
                          'default': '100',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '100',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_delayed_threads',
            'description': "Don't start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used",
            'name': 'max_delayed_threads',
            'values': ( { 'default': '20',
                          'maximum': '16384',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Various',
        ( { 'caption': 'tmp_table_size',
            'description': 'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table',
            'name': 'tmp_table_size',
            'values': ( { 'default': 'system dependent',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'lower_case_table_names',
            'description': 'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.',
            'name': 'lower_case_table_names',
            'values': ( { 'default': '0',
                          'maximum': '2',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction-isolation',
            'description': 'Default transaction isolation level',
            'name': 'transaction-isolation',
            'values': ( { 'choice': [ 'READ-UNCOMMITTED',
                                      'READ-COMMITTED',
                                      'REPEATABLE-READ',
                                      'SERIALIZABLE'],
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'temp-pool',
            'description': 'Using this option will cause most temporary files created to use a small set of names, rather than a unique name for each new file',
            'name': 'temp-pool',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_length_for_sort_data',
            'description': 'Max number of bytes in sorted records',
            'name': 'max_length_for_sort_data',
            'values': ( { 'default': '1024',
                          'maximum': '8388608',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-bdb',
            'description': 'Disable Berkeley DB (if this version of MySQL supports it)',
            'name': 'skip-bdb',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'query_prealloc_size',
            'description': 'Persistent buffer for query parsing and execution',
            'name': 'query_prealloc_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '8192',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '8192',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'big-tables',
            'description': 'Allow big result sets by saving all temporary sets on file',
            'name': 'big-tables',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_write_lock_count',
            'description': 'After this many write locks, allow some read locks to run in between',
            'name': 'max_write_lock_count',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'bind-address',
            'description': 'IP address or host name to bind to',
            'name': 'bind-address',
            'optype': { 'format': 'bind-address=name'},
            'values': ( { 'default': '0.0.0.0',
                          'maximum': '255.255.255.255',
                          'minimum': '0.0.0.0',
                          'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-merge',
            'description': 'Disable Merge storage engine',
            'name': 'skip-merge',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((5, 0, 24), (5, 1, 12)),
                          ((5, 0), (5, 1)),
                          ((5, 1, 14),))},
          { 'caption': 'max_join_size',
            'description': 'Joins that are probably going to read more than max_join_size records return an error',
            'name': 'max_join_size',
            'values': ( { 'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'group_concat_max_len',
            'description': 'The maximum length of the result of function group_concat',
            'name': 'group_concat_max_len',
            'values': ( { 'bitsize': '32',
                          'default': '1024',
                          'maximum': '4294967295',
                          'minimum': '4',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1024',
                          'maximum': '18446744073709547520',
                          'minimum': '4',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 10),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_seeks_for_key',
            'description': 'Limit assumed max number of seeks when looking up rows based on a key',
            'name': 'max_seeks_for_key',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delay-key-write',
            'description': 'Type of DELAY_KEY_WRITE',
            'name': 'delay-key-write',
            'values': ( { 'choice': ['ON', 'OFF', 'ALL'],
                          'default': 'ON',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'back_log',
            'description': 'The number of outstanding connection requests MySQL can have',
            'name': 'back_log',
            'values': ( { 'default': '50',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog_cache_size',
            'description': 'The size of the cache to hold the SQL statements for the binary log during a transaction',
            'name': 'binlog_cache_size',
            'values': ( { 'bitsize': '32',
                          'default': '32768',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '32768',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sql-mode',
            'description': 'Set the SQL server mode',
            'name': 'sql-mode',
            'values': ( { 'choice': [ 'ALLOW_INVALID_DATES',
                                      'ANSI_QUOTES',
                                      'ERROR_FOR_DIVISION_BY_ZERO',
                                      'HIGH_NOT_PRECEDENCE',
                                      'IGNORE_SPACE',
                                      'NO_AUTO_CREATE_USER',
                                      'NO_AUTO_VALUE_ON_ZERO',
                                      'NO_BACKSLASH_ESCAPES',
                                      'NO_DIR_IN_CREATE',
                                      'NO_ENGINE_SUBSTITUTION',
                                      'NO_FIELD_OPTIONS',
                                      'NO_KEY_OPTIONS',
                                      'NO_TABLE_OPTIONS',
                                      'NO_UNSIGNED_SUBTRACTION',
                                      'NO_ZERO_DATE',
                                      'NO_ZERO_IN_DATE',
                                      'ONLY_FULL_GROUP_BY',
                                      'PAD_CHAR_TO_FULL_LENGTH',
                                      'PIPES_AS_CONCAT',
                                      'REAL_AS_FLOAT',
                                      'STRICT_ALL_TABLES',
                                      'STRICT_TRANS_TABLES'],
                          'default': "''",
                          'type': 'set'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-new',
            'description': "Don't use new, possibly wrong routines",
            'name': 'skip-new',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-partition',
            'description': 'Do not enable user-defined partitioning',
            'name': 'skip-partition',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'key_cache_block_size',
            'description': 'The default size of key cache blocks',
            'name': 'key_cache_block_size',
            'values': ( { 'default': '1024',
                          'maximum': '16384',
                          'minimum': '512',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'core-file',
            'description': 'Write core on errors',
            'name': 'core-file',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-sync-bdb-logs',
            'deprecated': None,
            'description': 'Disables synchronous BDB log flushes',
            'name': 'skip-sync-bdb-logs',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'merge',
            'description': 'Enable Merge storage engine',
            'disabledby': 'skip-merge',
            'name': 'merge',
            'values': ( { 'default': 'true',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 21), (5, 0, 24), (5, 1, 12)),
                          ((4, 1), (5, 0), (5, 1)),
                          ((5, 1, 14),))},
          { 'caption': 'preload_buffer_size',
            'description': 'The size of the buffer that is allocated when preloading indexes',
            'name': 'preload_buffer_size',
            'values': ( { 'default': '32768',
                          'maximum': '1073741824',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction_alloc_block_size',
            'description': 'Allocation block size for transactions to be stored in binary log',
            'name': 'transaction_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'join_buffer_size',
            'description': 'The size of the buffer that is used for full joins',
            'name': 'join_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '131072',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'outversion': '6.0.8',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'default': '131072',
                          'inversion': '6.0.9',
                          'maximum': '4294967295',
                          'minimum': '128',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '131072',
                          'maximum': '18446744073709547520',
                          'minimum': '8200',
                          'outversion': '6.0.8',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '131072',
                          'inversion': '6.0.9',
                          'maximum': '18446744073709547520',
                          'minimum': '128',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'table_cache',
            'deprecated': (5, 1, 3),
            'description': 'The number of open tables for all threads',
            'name': 'table_cache',
            'values': ( { 'default': '64',
                          'maximum': '524288',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 3),))},
          { 'caption': 'read_rnd_buffer_size',
            'description': 'When reading rows in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.',
            'name': 'read_rnd_buffer_size',
            'values': ( { 'default': '262144',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_heap_table_size',
            'description': "Don't allow creation of heap tables bigger than this",
            'name': 'max_heap_table_size',
            'values': ( { 'bitsize': '32',
                          'default': '16777216',
                          'maximum': '4294967295',
                          'minimum': '16384',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '16777216',
                          'maximum': '1844674407370954752',
                          'minimum': '16384',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'symbolic-links',
            'description': 'Use symbolic links',
            'disabledby': 'skip-symbolic-links',
            'name': 'symbolic-links',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'chroot',
            'description': 'Chroot mysqld daemon during startup',
            'name': 'chroot',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_cache_division_limit',
            'description': 'The minimum percentage of warm blocks in key cache',
            'name': 'key_cache_division_limit',
            'values': ( { 'default': '100',
                          'maximum': '100',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_binlog_cache_size',
            'description': 'Can be used to restrict the total size used to cache a multi-transaction query',
            'name': 'max_binlog_cache_size',
            'values': ( { 'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'outversion': '5.1.35',
                          'type': 'numeric'},
                        { 'default': '18446744073709547520',
                          'inversion': '5.1.36',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'default': '4294967295',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '18446744073709547520',
                          'inversion': '5.4.2',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'default': '4294967295',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-symlink',
            'description': "Don't allow symlinking of tables. Deprecated option. Use --skip-symbolic-links.",
            'name': 'skip-symlink',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'new',
            'description': "Use very new, possibly 'unsafe' functions",
            'disabledby': 'skip-new',
            'name': 'new',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_sort_length',
            'description': 'The number of bytes to use when sorting BLOB or TEXT values',
            'name': 'max_sort_length',
            'values': ( { 'default': '1024',
                          'maximum': '8388608',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-isam',
            'deprecated': None,
            'description': 'Disable the ISAM storage engine',
            'name': 'skip-isam',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': (((4, 1, 1),), ((4, 1),), ())},
          { 'caption': 'ansi',
            'description': 'Use ANSI SQL syntax instead of MySQL syntax',
            'name': 'ansi',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'read_buffer_size',
            'description': 'Each thread that does a sequential scan allocates a buffer of this size for each table it scans',
            'name': 'read_buffer_size',
            'values': ( { 'default': '131072',
                          'maximum': '2147479552',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'user',
            'description': 'Run mysqld daemon as user',
            'name': 'user',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'range_alloc_block_size',
            'description': 'Allocation block size for storing ranges during optimization',
            'name': 'range_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '2048',
                          'maximum': '4294967295',
                          'minimum': '2048',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '4096',
                          'inversion': '5.0.54',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '2048',
                          'maximum': '18446744073709547520',
                          'minimum': '2048',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '4096',
                          'inversion': '5.0.54',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'pid-file',
            'description': 'Process ID file used by mysqld_safe',
            'name': 'pid-file',
            'optype': { 'format': 'pid-file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_alloc_block_size',
            'description': 'Allocation block size for query parsing and execution',
            'name': 'query_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'bulk_insert_buffer_size',
            'description': 'Size of tree cache used in bulk insert optimization',
            'name': 'bulk_insert_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_tmp_tables',
            'description': 'Maximum number of temporary tables a client can keep open at a time',
            'name': 'max_tmp_tables',
            'values': ( { 'bitsize': '32',
                          'default': '32',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '32',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction_prealloc_size',
            'description': 'Persistent buffer for transactions to be stored in binary log',
            'name': 'transaction_prealloc_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '4096',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '4096',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog_direct_non_transactional_updates',
            'description': 'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.',
            'name': 'binlog_direct_non_transactional_updates',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 44), (5, 5, 2), (6, 0, 14)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( 'MyISAM Parameters',
    ( ( 'General',
        ( { 'caption': 'concurrent_insert',
            'description': 'Use concurrent insert with MyISAM',
            'disabledby': 'skip-concurrent-insert',
            'name': 'concurrent_insert',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'outversion': '5.0.5',
                          'type': 'boolean'},
                        { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'inversion': '5.0.6',
                          'outversion': '5.5.2',
                          'type': 'numeric'},
                        { 'choice': [ 'NEVER',
                                      'AUTO',
                                      'ALWAYS',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'AUTO',
                          'inversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'inversion': '6.0.0',
                          'outversion': '6.0.14',
                          'type': 'numeric'},
                        { 'choice': [ 'NEVER',
                                      'AUTO',
                                      'ALWAYS',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'AUTO',
                          'inversion': '6.0.14',
                          'type': 'dropdownbox'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'keep_files_on_create',
            'description': 'Do not overwrite existing .MYD/.MYI files in default database directory',
            'name': 'keep_files_on_create',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 48), (5, 1, 21)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_buffer_size',
            'description': 'The size of the buffer used for index blocks for MyISAM tables',
            'name': 'key_buffer_size',
            'values': ( { 'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '8',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'default': '8388608',
                          'inversion': '5.1.23',
                          'maximum': '4294967295',
                          'minimum': '8',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'inversion': '5.1.23',
                          'maximum': 'OS_PER_PROCESS_LIMIT',
                          'minimum': '8',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-locking',
            'deprecated': None,
            'description': 'Deprecated option',
            'name': 'skip-locking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_cache_age_threshold',
            'description': 'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache',
            'name': 'key_cache_age_threshold',
            'values': ( { 'bitsize': '32',
                          'default': '300',
                          'maximum': '4294967295',
                          'minimum': '100',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '300',
                          'maximum': '18446744073709547520',
                          'minimum': '100',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'external-locking',
            'description': 'Use system (external) locking',
            'disabledby': 'skip-external-locking',
            'name': 'external-locking',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Fulltext search',
        ( { 'caption': 'ft_min_word_len',
            'description': 'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
            'name': 'ft_min_word_len',
            'values': ( { 'default': '4',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_boolean_syntax',
            'description': 'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)',
            'name': 'ft_boolean_syntax',
            'values': ({ 'default': '+-><()~*:""&', 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_max_word_len',
            'description': 'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
            'name': 'ft_max_word_len',
            'values': ({ 'minimum': '10', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_stopword_file',
            'description': 'Use stopwords from this file instead of built-in list',
            'name': 'ft_stopword_file',
            'optype': { 'format': 'ft_stopword_file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( ((4, 1, 10),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_query_expansion_limit',
            'description': 'Number of best matches to use for query expansion',
            'name': 'ft_query_expansion_limit',
            'values': ( { 'default': '20',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Advanced Settings',
        ( { 'caption': 'skip-concurrent-insert',
            'description': 'Turn off the ability to select and insert at the same time on MyISAM tables',
            'name': 'skip-concurrent-insert',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam-recover-options',
            'description': 'Set the mode for automatic MyISAM recovery',
            'name': 'myisam-recover-options',
            'values': ( { 'choice': [ 'OFF',
                                      'DEFAULT',
                                      'BACKUP',
                                      'FORCE',
                                      'QUICK'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'myisam_sort_buffer_size',
            'description': 'The buffer that is allocated when sorting the index when doing a REPAIR or when creating indexes with CREATE INDEX or ALTER TABLE',
            'name': 'myisam_sort_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '4',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'maximum': '18446744073709547520',
                          'minimum': '4',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_max_extra_sort_file_size',
            'deprecated': (5, 0, 6),
            'description': 'Deprecated option',
            'name': 'myisam_max_extra_sort_file_size',
            'optype': { 'outversion': '5.0.6'},
            'values': ( { 'default': '2147483648',
                          'outversion': '5.0.6',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'myisam_use_mmap',
            'description': 'Use memory mapping for reading and writing MyISAM tables',
            'name': 'myisam_use_mmap',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 4),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'myisam_stats_method',
            'description': 'Specifies how MyISAM index statistics collection code should treat NULLs',
            'name': 'myisam_stats_method',
            'values': ( { 'default': 'nulls_unequal',
                          'inversion': '4.1',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'nulls_equal',
                                      'nulls_unequal',
                                      'nulls_ignored'],
                          'inversion': '5.0',
                          'type': 'dropdownbox'}),
            'versions': ( ((4, 1, 15), (5, 0, 14)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam-recover',
            'description': 'Set the mode for automatic MyISAM recovery',
            'name': 'myisam-recover',
            'values': ( { 'choice': [ 'DEFAULT',
                                      'BACKUP',
                                      'FORCE',
                                      'QUICK'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 3), (6, 0, 14)))},
          { 'caption': 'myisam-block-size',
            'description': 'Block size to be used for MyISAM index pages',
            'name': 'myisam-block-size',
            'values': ( { 'default': '1024',
                          'maximum': '16384',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_max_sort_file_size',
            'description': "Don't use the fast sort index method to create index if the temporary file would get bigger than this",
            'name': 'myisam_max_sort_file_size',
            'values': ({ 'default': '2147483648', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_data_pointer_size',
            'description': 'Default pointer size to be used for MyISAM tables',
            'name': 'myisam_data_pointer_size',
            'values': ( { 'default': '4',
                          'maximum': '8',
                          'minimum': '2',
                          'outversion': '5.0.5',
                          'type': 'numeric'},
                        { 'default': '6',
                          'inversion': '5.0.6',
                          'maximum': '7',
                          'minimum': '2',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_repair_threads',
            'description': 'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair',
            'name': 'myisam_repair_threads',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_mmap_size',
            'description': 'The maximum amount of memory to use for memory mapping compressed MyISAM files.',
            'name': 'myisam_mmap_size',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '7',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '7',
                          'type': 'numeric'}),
            'versions': ( ( (5, 0, 90),
                            (5, 1, 43),
                            (5, 5, 1),
                            (6, 0, 14)),
                          ((5, 0), (5, 1), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( 'Performance',
    ( ( 'General',
        ( { 'caption': 'safe-mode',
            'deprecated': (5, 0),
            'description': 'Skip some optimization stages (for testing)',
            'name': 'safe-mode',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'table_open_cache',
            'description': 'The number of open tables for all threads',
            'name': 'table_open_cache',
            'values': ( { 'default': '64',
                          'maximum': '524288',
                          'minimum': '64',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.0',
                          'maximum': '524288',
                          'minimum': '64',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.2',
                          'maximum': '524288',
                          'minimum': '400',
                          'type': 'numeric'},
                        { 'default': '64',
                          'inversion': '6.0.0',
                          'maximum': '524288',
                          'minimum': '64',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 3),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'table_definition_cache',
            'description': 'The number of table definitions that can be stored in the definition cache.',
            'name': 'table_definition_cache',
            'values': ( { 'default': '128',
                          'maximum': '524288',
                          'minimum': '1',
                          'outversion': '5.1.24',
                          'type': 'numeric'},
                        { 'default': '256',
                          'inversion': '5.1.25',
                          'maximum': '524288',
                          'minimum': '256',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.0',
                          'maximum': '524288',
                          'minimum': '400',
                          'type': 'numeric'},
                        { 'default': '128',
                          'inversion': '6.0.0',
                          'maximum': '524288',
                          'minimum': '1',
                          'outversion': '6.0.5',
                          'type': 'numeric'},
                        { 'default': '256',
                          'inversion': '6.0.6',
                          'maximum': '524288',
                          'minimum': '256',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 3),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( 'Query cache',
        ( { 'caption': 'query_cache_size',
            'description': 'The memory allocated to store results from old queries',
            'name': 'query_cache_size',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_wlock_invalidate',
            'description': 'Invalidate queries in query cache on LOCK for write',
            'name': 'query_cache_wlock_invalidate',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_min_res_unit',
            'description': 'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)',
            'name': 'query_cache_min_res_unit',
            'values': ( { 'bitsize': '32',
                          'default': '4096',
                          'maximum': '4294967295',
                          'minimum': '512',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '4096',
                          'maximum': '18446744073709547520',
                          'minimum': '512',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-same-server-id',
            'description': 'In replication, if set to 1, do not skip events having our server id',
            'name': 'replicate-same-server-id',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_limit',
            'description': "Don't cache results that are bigger than this",
            'name': 'query_cache_limit',
            'values': ( { 'bitsize': '32',
                          'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1048576',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_type',
            'description': 'Query cache type',
            'name': 'query_cache_type',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Optimize',
        ( { 'caption': 'optimizer_switch',
            'description': 'Enable control over which optimizations to use',
            'name': 'optimizer_switch',
            'optype': { 'inversion': '5.1.34'},
            'values': ( { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'outversion': '5.2.3',
                          'type': 'set'},
                        { 'choice': [ 'no_semijoin',
                                      'no_materialization'],
                          'default': "''",
                          'inversion': '5.2.4',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'inversion': '5.4.2',
                          'outversion': '5.5.2',
                          'type': 'set'},
                        { 'choice': [ 'engine_condition_pushdown={on|off}',
                                      'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'inversion': '5.5.3',
                          'type': 'set'},
                        { 'choice': [ 'no_firstmatch',
                                      'no_loosescan',
                                      'no_materialization',
                                      'no_semijoin'],
                          'default': "''",
                          'inversion': '6.0.0',
                          'outversion': '6.0.10',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}',
                                      'semijoin={on|off}',
                                      'firstmatch={on|off}',
                                      'loosescan={on|off}',
                                      'materialization={on|off}'],
                          'inversion': '6.0.11',
                          'outversion': '6.0.13',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}',
                                      'semijoin={on|off}',
                                      'firstmatch={on|off}',
                                      'loosescan={on|off}',
                                      'materialization={on|off}',
                                      'engine_condition_pushdown={on|off}',
                                      'index_condition_pushdown={on|off}',
                                      'mrr={on|off}',
                                      'mrr_cost_based={on|off}'],
                          'inversion': '6.0.14',
                          'type': 'set'}),
            'versions': ( ((5, 1, 34), (5, 2, 4), (5, 4, 2)),
                          ( (5, 1),
                            (5, 2),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'optimizer_prune_level',
            'description': 'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space',
            'name': 'optimizer_prune_level',
            'values': ( { 'default': '1',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 1),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'optimizer_search_depth',
            'description': 'Maximum depth of search performed by the query optimizer',
            'name': 'optimizer_search_depth',
            'values': ( { 'default': '62', 'type': 'numeric'},
                        { 'default': '62',
                          'maximum': '63',
                          'minimum': '0',
                          'outversion': '5.5.99',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '5.6',
                          'maximum': '62',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '6.0.0',
                          'maximum': '63',
                          'minimum': '0',
                          'outversion': '6.0.13',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '6.0.14',
                          'maximum': '62',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 1),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Performance Schema',
        ( { 'caption': 'performance_schema_max_thread_instances',
            'description': 'The maximum number of instrumented thread objects',
            'name': 'performance_schema_max_thread_instances',
            'optype': { 'format': 'performance_schema_max_thread_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_file_classes',
            'description': 'The maximum number of file instruments',
            'name': 'performance_schema_max_file_classes',
            'optype': { 'format': 'performance_schema_max_file_classes=#'},
            'values': ({ 'default': '50', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema',
            'description': 'Whether Performance Schema is enabled',
            'name': 'performance_schema',
            'optype': { 'format': 'performance_schema=#'},
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_file_instances',
            'description': 'The maximum number of instrumented file objects',
            'name': 'performance_schema_max_file_instances',
            'optype': { 'format': 'performance_schema_max_file_instances=#'},
            'values': ({ 'default': '10000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_file_handles',
            'description': 'The maximum number of opened file objects',
            'name': 'performance_schema_max_file_handles',
            'optype': { 'format': 'performance_schema_max_file_handles=#'},
            'values': ({ 'default': '32768', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_events_waits_history_size',
            'description': 'The number of rows in EVENTS_WAITS_HISTORY',
            'name': 'performance_schema_events_waits_history_size',
            'optype': { 'format': 'performance_schema_events_waits_history_size=#'},
            'values': ({ 'default': '10', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_table_handles',
            'description': 'The maximum number of opened table objects',
            'name': 'performance_schema_max_table_handles',
            'optype': { 'format': 'performance_schema_max_table_handles=#'},
            'values': ({ 'default': '100000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_thread_classes',
            'description': 'The maximum number of thread instruments',
            'name': 'performance_schema_max_thread_classes',
            'optype': { 'format': 'performance_schema_max_thread_classes=#'},
            'values': ({ 'default': '50', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_mutex_instances',
            'description': 'The maximum number of instrumented mutex objects',
            'name': 'performance_schema_max_mutex_instances',
            'optype': { 'format': 'performance_schema_max_mutex_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_rwlock_classes',
            'description': 'The maximum number of rwlock instruments',
            'name': 'performance_schema_max_rwlock_classes',
            'optype': { 'format': 'performance_schema_max_rwlock_classes=#'},
            'values': ({ 'default': '20', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_table_instances',
            'description': 'The maximum number of instrumented table objects',
            'name': 'performance_schema_max_table_instances',
            'optype': { 'format': 'performance_schema_max_table_instances=#'},
            'values': ({ 'default': '50000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_events_waits_history_long_size',
            'description': 'The number of rows in EVENTS_WAITS_HISTORY_LONG',
            'name': 'performance_schema_events_waits_history_long_size',
            'optype': { 'format': 'performance_schema_events_waits_history_long_size=#'},
            'values': ({ 'default': '10000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_rwlock_instances',
            'description': 'The maximum number of instrumented rwlock objects',
            'name': 'performance_schema_max_rwlock_instances',
            'optype': { 'format': 'performance_schema_max_rwlock_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_cond_instances',
            'description': 'The maximum number of instrumented condition objects',
            'name': 'performance_schema_max_cond_instances',
            'optype': { 'format': 'performance_schema_max_cond_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_cond_classes',
            'description': 'The maximum number of condition instruments',
            'name': 'performance_schema_max_cond_classes',
            'optype': { 'format': 'performance_schema_max_cond_classes=#'},
            'values': ({ 'default': '80', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_mutex_classes',
            'description': 'The maximum number of mutex instruments',
            'name': 'performance_schema_max_mutex_classes',
            'optype': { 'format': 'performance_schema_max_mutex_classes=#'},
            'values': ({ 'default': '200', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( 'Log Files',
    ( ( 'Activate Logging',
        ( { 'caption': 'log-isam',
            'description': 'Log all MyISAM changes to file',
            'name': 'log-isam',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log',
            'deprecated': (5, 1, 29),
            'description': 'Log connections and queries to file',
            'name': 'log',
            'values': ({ 'default': 'OFF', 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-error',
            'description': 'Error log file',
            'name': 'log-error',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slow-queries',
            'deprecated': (5, 1, 29),
            'description': 'Whether or not to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options',
            'name': 'log-slow-queries',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'general-log',
            'description': 'Enable|disable general log',
            'name': 'general-log',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-bin',
            'description': 'Enables binary log',
            'name': 'log-bin',
            'values': ({ 'default': 'OFF', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Binlog Options',
        ( { 'caption': 'max-binlog-dump-events',
            'description': 'Option used by mysql-test for debugging and testing of replication',
            'name': 'max-binlog-dump-events',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-do-db',
            'description': 'Limits binary logging to specific databases',
            'name': 'binlog-do-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-format',
            'description': 'Specifies the format of the binary log',
            'name': 'binlog-format',
            'optype': { 'format': 'binlog-format=format'},
            'values': ( { 'choice': ['ROW', 'STATEMENT'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.5',
                          'outversion': '5.1.7',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.8',
                          'outversion': '5.1.11',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.12',
                          'outversion': '5.1.28',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.14-ndb-6.1.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.16-ndb-6.2.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.19-ndb-6.3.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.29',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 5),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'max_binlog_size',
            'description': 'Binary log will be rotated automatically when the size exceeds this value',
            'name': 'max_binlog_size',
            'values': ( { 'default': '1073741824',
                          'maximum': '1073741824',
                          'minimum': '4096',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-index',
            'description': 'File that holds the names for last binary log files',
            'name': 'log-bin-index',
            'values': ({ 'default': 'OFF', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-row-event-max-size',
            'description': 'Binary log max event size',
            'name': 'binlog-row-event-max-size',
            'values': ( { 'bitsize': '32',
                          'default': '1024',
                          'maximum': '4294967295',
                          'minimum': '256',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1024',
                          'maximum': '18446744073709547520',
                          'minimum': '256',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 5),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'sync_binlog',
            'description': 'Synchronously flush binary log to disk after every #th event',
            'name': 'sync_binlog',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 3), (5, 0, 1)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-trust-routine-creators',
            'deprecated': (5, 0, 16),
            'description': '(deprecated) Use log-bin-trust-function-creators',
            'name': 'log-bin-trust-routine-creators',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 6),),
                          ( (5, 0),
                            (5, 1),
                            (5, 2),
                            (5, 4),
                            (5, 5),
                            (5, 6)),
                          ((5, 2, 5), (5, 5, 3)))},
          { 'caption': 'binlog-ignore-db',
            'description': 'Tells the master that updates to the given database should not be logged to the binary log',
            'name': 'binlog-ignore-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-trust-function-creators',
            'description': 'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging',
            'name': 'log-bin-trust-function-creators',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 16),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sporadic-binlog-dump-fail',
            'description': 'Option used by mysql-test for debugging and testing of replication',
            'name': 'sporadic-binlog-dump-fail',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Slow query log options',
        ( { 'caption': 'log-slow-admin-statements',
            'description': 'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open',
            'name': 'log-slow-admin-statements',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 13),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slow-slave-statements',
            'description': 'Cause slow statements as executed by the slave to be written to the slow query log',
            'name': 'log-slow-slave-statements',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 21), (6, 0, 4)),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'slow_query_log_file',
            'description': 'Name of the slow query log file',
            'name': 'slow_query_log_file',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'long_query_time',
            'description': 'Log all queries that have taken more than long_query_time seconds to execute to file',
            'name': 'long_query_time',
            'values': ( { 'default': '10',
                          'minimum': '1',
                          'outversion': '5.0.20',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.1.21',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '10',
                          'minimum': '1',
                          'outversion': '6.0.3',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '6.0.4',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slow-query-log',
            'description': 'Enable|disable slow query log',
            'name': 'slow-query-log',
            'optype': { 'inversion': '5.1.29'},
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( 'Advanced log options',
        ( { 'caption': 'log-short-format',
            'description': "Don't log extra information to update and slow-query logs",
            'name': 'log-short-format',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'general_log_file',
            'description': 'Name of the general query log file',
            'name': 'general_log_file',
            'optype': { 'inversion': '5.1.29'},
            'values': ({ 'default': 'host_name.log', 'type': 'filename'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-tc',
            'description': 'Path to transaction coordinator log (used for transactions that affect more than one storage engine, when binary log is disabled)',
            'name': 'log-tc',
            'values': ({ 'default': 'tc.log', 'type': 'filename'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'min-examined-row-limit',
            'description': 'Queries examining fewer than this number of rows are not logged to slow query log',
            'name': 'min-examined-row-limit',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 21), (6, 0, 4)),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-warnings',
            'description': 'Log some noncritical warnings to the log file',
            'disabledby': 'skip-log-warnings',
            'name': 'log-warnings',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'inversion': '4.1.3',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'inversion': '4.1.3',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-tc-size',
            'description': 'Size in KB of transaction coordinator log',
            'name': 'log-tc-size',
            'values': ( { 'bitsize': '32',
                          'default': '24576',
                          'maximum': '4294967295',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '24576',
                          'maximum': '18446744073709547520',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-queries-not-using-indexes',
            'description': 'Log queries that are executed without benefit of any index to the slow query log if it is open',
            'name': 'log-queries-not-using-indexes',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'expire_logs_days',
            'description': 'If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation',
            'name': 'expire_logs_days',
            'values': ( { 'default': '0',
                          'maximum': '99',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-output',
            'description': 'The destination for general query log and slow query log output. Syntax: log-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
            'name': 'log-output',
            'values': ( { 'choice': ['TABLE', 'FILE', 'NONE'],
                          'default': 'FILE',
                          'type': 'set'},),
            'versions': ( ((5, 1, 6),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( 'Security',
    ( ( 'Security',
        ( { 'caption': 'local-infile',
            'description': 'Enable/disable LOAD DATA LOCAL INFILE (takes values 1|0)',
            'name': 'local-infile',
            'values': ( { 'default': 'true',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-grant-tables',
            'description': 'Start without grant tables. This gives all users FULL ACCESS to all tables',
            'name': 'skip-grant-tables',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'des-key-file',
            'description': 'Load keys for des_encrypt() and des_encrypt from given file',
            'name': 'des-key-file',
            'optype': { 'format': 'des-key-file=file_name'},
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'read_only',
            'description': 'Make all nontemporary tables read only',
            'name': 'read_only',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'secure-auth',
            'description': 'Disallow authentication for accounts that have old (pre-4.1) passwords',
            'name': 'secure-auth',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'safemalloc-mem-limit',
            'description': 'Simulate memory shortage',
            'name': 'safemalloc-mem-limit',
            'values': ({ 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 6),))},
          { 'caption': 'safe-user-create',
            'description': "Don't allow new user creation by the user who has no write privileges to the mysql.user table",
            'name': 'safe-user-create',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'secure-file-priv',
            'description': 'Limit LOAD_FILE(), LOAD DATA, and SELECT ... INTO OUTFILE to files in specified directory',
            'name': 'secure-file-priv',
            'optype': { 'format': 'secure-file-priv=path'},
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 38), (5, 1, 17)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-passwords',
            'description': 'Use old password encryption method (needed for 4.0 and older clients)',
            'name': 'old-passwords',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'safe-show-database',
            'deprecated': (4, 0, 2),
            'description': 'Deprecated option; use GRANT SHOW DATABASES instead',
            'name': 'safe-show-database',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'allow-suspicious-udfs',
            'description': 'Allows use of UDFs consisting of only one symbol xxx() without corresponding xxx_init() or xxx_deinit()',
            'name': 'allow-suspicious-udfs',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 10), (5, 0, 3)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-show-database',
            'description': "Don't allow 'SHOW DATABASE' commands",
            'name': 'skip-show-database',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'SSL',
        ( { 'caption': 'ssl-cipher',
            'description': 'SSL cipher to use (implies --ssl)',
            'name': 'ssl-cipher',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl',
            'description': 'Enable SSL for connection (automatically enabled with other flags)',
            'disabledby': 'skip-ssl',
            'name': 'ssl',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-verify-server-cert',
            'description': 'For clients, verify server host name against Common Name in server certificate',
            'name': 'ssl-verify-server-cert',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((5, 1, 11),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'ssl-capath',
            'description': 'CA directory (check OpenSSL docs, implies --ssl)',
            'name': 'ssl-capath',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-ca',
            'description': 'CA file in PEM format (check OpenSSL docs, implies --ssl)',
            'name': 'ssl-ca',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-ssl',
            'description': "Don't use ssl",
            'name': 'skip-ssl',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-cert',
            'description': 'X509 cert in PEM format (implies --ssl)',
            'name': 'ssl-cert',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-key',
            'description': 'X509 key in PEM format (implies --ssl)',
            'name': 'ssl-key',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( 'InnoDB Parameters',
    ( ( 'General',
        ( { 'caption': 'innodb_replication_delay',
            'description': 'The slave server replication thread delay',
            'name': 'innodb_replication_delay',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_checksums',
            'description': 'Enable InnoDB checksums validation',
            'name': 'innodb_checksums',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_use_legacy_cardinality_algorithm',
            'description': 'Whether to use legacy InnoDB index cardinality calculation algorithm',
            'name': 'innodb_use_legacy_cardinality_algorithm',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 0, 82), (5, 1, 35)), ((5, 0), (5, 1)), ())},
          { 'caption': 'innodb_autoextend_increment',
            'description': 'Data file autoextend increment in megabytes',
            'name': 'innodb_autoextend_increment',
            'values': ( { 'default': '8',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '64',
                          'inversion': '5.4.0',
                          'maximum': '1000',
                          'minimum': '1',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '6.0.0',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 5),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_stats_on_metadata',
            'description': 'Enable or disable InnoDB table statistics updates for metadata statements',
            'name': 'innodb_stats_on_metadata',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 17),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'innodb_stats_sample_pages',
            'description': 'The number of index pages to sample for index distribution statistics',
            'name': 'innodb_stats_sample_pages',
            'values': ({ 'default': '8', 'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_autoinc_lock_mode',
            'description': 'Set InnoDB auto-increment lock mode',
            'name': 'innodb_autoinc_lock_mode',
            'values': ({ 'default': '1', 'type': 'numeric'},),
            'versions': ( ((5, 1, 22),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'innodb_old_blocks_time',
            'description': 'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end',
            'name': 'innodb_old_blocks_time',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': (((5, 1, 41),), ((5, 1), (5, 5), (5, 6)), ())},
          { 'caption': 'innodb_use_sys_malloc',
            'description': 'Whether InnoDB uses the OS or its own memory allocator',
            'name': 'innodb_use_sys_malloc',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_table_locks',
            'description': 'Enable InnoDB locking in LOCK TABLES',
            'name': 'innodb_table_locks',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_spin_wait_delay',
            'description': 'The maximum delay between polls for a spin lock',
            'name': 'innodb_spin_wait_delay',
            'values': ( { 'default': '6',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'ignore-builtin-innodb',
            'description': 'Ignore the built-in InnoDB',
            'name': 'ignore-builtin-innodb',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((5, 1, 33),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_thread_sleep_delay',
            'description': 'Time of innodb thread sleeping before joining InnoDB queue (usec). Value 0 disable a sleep',
            'name': 'innodb_thread_sleep_delay',
            'values': ( { 'default': '0',
                          'inversion': '5.0.8',
                          'maximum': '4294967295',
                          'minimum': '1000',
                          'outversion': '5.0.18',
                          'type': 'numeric'},
                        { 'default': '0',
                          'inversion': '5.0.19',
                          'maximum': '4294967295',
                          'minimum': '1000',
                          'outversion': '5.0.20',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '5.0.21',
                          'type': 'numeric'},
                        { 'default': '10000',
                          'inversion': '5.1.0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb-status-file',
            'description': 'Enable SHOW INNODB STATUS output in the innodb_status.[pid] file',
            'name': 'innodb-status-file',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_max_purge_lag',
            'description': 'Desired maximum length of the purge queue (0 = no limit)',
            'name': 'innodb_max_purge_lag',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 6),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_file_format_check',
            'description': 'Whether InnoDB performs file format compatibility checking',
            'name': 'innodb_file_format_check',
            'values': ( { 'default': 'Antelope',
                          'outversion': '5.1.41',
                          'type': 'string'},
                        { 'default': 'Barracuda',
                          'inversion': '5.1.42',
                          'type': 'string'},
                        { 'default': 'Antelope',
                          'outversion': '5.5.0',
                          'type': 'string'},
                        { 'default': 'Barracuda',
                          'inversion': '5.5.4',
                          'type': 'string'},
                        { 'default': 'on',
                          'inversion': '5.5.5',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_file_format',
            'description': 'The format for new InnoDB tables',
            'name': 'innodb_file_format',
            'values': ( { 'default': 'Antelope',
                          'inversion': '5.1.38',
                          'type': 'string'},
                        { 'default': 'Barracuda',
                          'inversion': '5.5.0',
                          'outversion': '5.5.6',
                          'type': 'string'},
                        { 'default': 'Antelope',
                          'inversion': '5.5.7',
                          'type': 'string'},
                        { 'default': 'Antelope',
                          'inversion': '5.6.1',
                          'type': 'string'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_strict_mode',
            'description': 'Whether InnoDB returns errors rather than warnings for exceptional conditions',
            'name': 'innodb_strict_mode',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_old_blocks_pct',
            'description': 'Percentage of the InnoDB buffer pool to reserve for old blocks',
            'name': 'innodb_old_blocks_pct',
            'values': ( { 'default': '37',
                          'maximum': '95',
                          'minimum': '5',
                          'type': 'numeric'},),
            'versions': (((5, 1, 41),), ((5, 1), (5, 5), (5, 6)), ())},
          { 'caption': 'timed_mutexes',
            'description': 'Specify whether to time mutexes (only InnoDB mutexes are currently supported)',
            'name': 'timed_mutexes',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_adaptive_hash_index',
            'description': 'Enable or disable InnoDB adaptive hash indexes',
            'name': 'innodb_adaptive_hash_index',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 52), (5, 1, 24), (6, 0, 5)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_read_io_threads',
            'description': 'The number of background I/O threads for read prefetch requests',
            'name': 'innodb_read_io_threads',
            'values': ( { 'default': '8',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '4',
                          'inversion': '5.4.3',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_doublewrite',
            'description': 'Enable InnoDB doublewrite buffer',
            'name': 'innodb_doublewrite',
            'values': ({ 'type': 'numeric'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_locks_unsafe_for_binlog',
            'description': 'Force InnoDB not to use next-key locking. Instead use only row-level locking',
            'name': 'innodb_locks_unsafe_for_binlog',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 4),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_adaptive_flushing',
            'description': 'Control InnoDB adaptive flushing of dirty pages',
            'name': 'innodb_adaptive_flushing',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_sync_spin_loops',
            'description': 'Count of spin-loop rounds in InnoDB mutexes',
            'name': 'innodb_sync_spin_loops',
            'values': ( { 'default': '20',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '30',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_read_ahead_threshold',
            'description': 'The sensitivity of InnoDB linear read-ahead',
            'name': 'innodb_read_ahead_threshold',
            'values': ( { 'default': '56',
                          'maximum': '64',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_change_buffering',
            'description': 'Whether InnoDB performs insert buffering.',
            'name': 'innodb_change_buffering',
            'values': ( { 'choice': ['inserts', 'none'],
                          'default': 'inserts',
                          'outversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'inserts',
                                      'deletes',
                                      'purges',
                                      'changes',
                                      'all',
                                      'none'],
                          'default': 'all',
                          'inversion': '5.5.4',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_concurrency_tickets',
            'description': 'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket',
            'name': 'innodb_concurrency_tickets',
            'values': ( { 'default': '500',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_support_xa',
            'description': 'Enable InnoDB support for the XA two-phase commit',
            'name': 'innodb_support_xa',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_io_capacity',
            'description': 'The limit on the maximum number of I/O operations per second',
            'name': 'innodb_io_capacity',
            'values': ( { 'default': '200',
                          'minimum': '100',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_commit_concurrency',
            'description': 'Helps in performance tuning in heavily concurrent environments',
            'name': 'innodb_commit_concurrency',
            'values': ( { 'default': '0',
                          'maximum': '100',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 12),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_rollback_on_timeout',
            'description': 'Roll back entire transaction on transaction timeout, not just last statement',
            'name': 'innodb_rollback_on_timeout',
            'values': (),
            'versions': ( ((5, 0, 32), (5, 1, 15)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_write_io_threads',
            'description': 'The number of background I/O threads for writing dirty pages from the buffer cache to disk',
            'name': 'innodb_write_io_threads',
            'values': ( { 'default': '8',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '4',
                          'inversion': '5.4.3',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())})),
      ( 'Activate InnoDB',
        ( { 'caption': 'innodb',
            'description': 'Enable InnoDB (if this version of MySQL supports it)',
            'name': 'innodb',
            'values': ( { 'off': '0',
                          'on': '1',
                          'outversion': '5.1.35',
                          'type': 'boolean'},
                        { 'choice': ['OFF', 'ON', 'FORCE'],
                          'inversion': '5.1.36',
                          'type': 'dropdownbox'},
                        { 'inversion': '5.4.0',
                          'off': '0',
                          'on': '1',
                          'outversion': '5.4.1',
                          'type': 'boolean'},
                        { 'choice': ['OFF', 'ON', 'FORCE'],
                          'inversion': '5.4.2',
                          'type': 'dropdownbox'},
                        { 'inversion': '6.0.0',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( 'Memory',
        ( { 'caption': 'innodb_buffer_pool_awe_mem_mb',
            'description': 'If Windows AWE is used, the size in Megabytes of InnoDB buffer pool allocated from the AWE memory',
            'name': 'innodb_buffer_pool_awe_mem_mb',
            'values': ( { 'default': '0',
                          'maximum': '63000',
                          'minimum': '0',
                          'platform': 'windows',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 13),))},
          { 'caption': 'innodb_buffer_pool_size',
            'description': 'The size of the memory buffer InnoDB uses to cache data and indexes of its tables',
            'name': 'innodb_buffer_pool_size',
            'values': ( { 'default': '8388608',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'maximum': '2**32-1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'maximum': '2**64-1',
                          'type': 'numeric'},
                        { 'default': '1073741824',
                          'inversion': '5.4.0',
                          'minimum': '67108864',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '1073741824',
                          'inversion': '5.4.2',
                          'minimum': '5242880',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '134217728',
                          'inversion': '5.4.3',
                          'minimum': '5242880',
                          'type': 'numeric'},
                        { 'default': '8388608',
                          'inversion': '6.0.0',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_additional_mem_pool_size',
            'description': 'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures',
            'name': 'innodb_additional_mem_pool_size',
            'values': ( { 'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '524288',
                          'type': 'numeric'},
                        { 'default': '8388608',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '2097152',
                          'type': 'numeric'},
                        { 'default': '1048576',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '524288',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Datafiles',
        ( { 'caption': 'innodb_file_per_table',
            'description': 'Stores each InnoDB table to an .ibd file in the database dir',
            'name': 'innodb_file_per_table',
            'values': ( { 'default': 'off',
                          'inversion': '4.1.1',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'on',
                          'inversion': '5.5.0',
                          'off': 'off',
                          'on': 'on',
                          'outversion': '5.5.6',
                          'type': 'boolean'},
                        { 'default': 'off',
                          'inversion': '5.5.7',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'off',
                          'inversion': '5.6.1',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_data_file_path',
            'description': 'Path to individual files and their sizes',
            'name': 'innodb_data_file_path',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_data_home_dir',
            'description': 'The common part for InnoDB table spaces',
            'name': 'innodb_data_home_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Logfiles',
        ( { 'caption': 'innodb_log_buffer_size',
            'description': 'The size of the buffer which InnoDB uses to write log to the log files on disk',
            'name': 'innodb_log_buffer_size',
            'values': ( { 'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'default': '16777216',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '2097152',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '16777216',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '262144',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '8388608',
                          'inversion': '5.4.3',
                          'maximum': '4294967295',
                          'minimum': '262144',
                          'type': 'numeric'},
                        { 'default': '1048576',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_arch_dir',
            'deprecated': (5, 0, 24),
            'description': 'Where full logs should be archived',
            'name': 'innodb_log_arch_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 21),))},
          { 'caption': 'innodb_log_archive',
            'description': 'Unused',
            'name': 'innodb_log_archive',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 18),))},
          { 'caption': 'innodb_mirrored_log_groups',
            'description': 'Number of identical copies of log groups we keep for the database',
            'name': 'innodb_mirrored_log_groups',
            'values': ( { 'default': '1',
                          'maximum': '10',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_file_size',
            'description': 'Size of each log file in a log group',
            'name': 'innodb_log_file_size',
            'values': ( { 'default': '5242880',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'default': '134217728',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '33554432',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '134217728',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '108576',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '5242880',
                          'inversion': '5.4.3',
                          'maximum': '4294967295',
                          'minimum': '108576',
                          'type': 'numeric'},
                        { 'default': '5242880',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_flush_method',
            'description': 'With which method to flush data',
            'name': 'innodb_flush_method',
            'values': ( { 'default': 'async_unbuffered',
                          'platform': 'windows',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'linux',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'linux',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'hpux',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'hpux',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'solaris',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'solaris',
                          'type': 'dropdownbox'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_files_in_group',
            'description': 'Number of InnoDB log files in the log group',
            'name': 'innodb_log_files_in_group',
            'values': ( { 'default': '2',
                          'maximum': '100',
                          'minimum': '2',
                          'type': 'numeric'},
                        { 'default': '3',
                          'inversion': '5.4.0',
                          'maximum': '100',
                          'minimum': '3',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '2',
                          'inversion': '5.4.3',
                          'maximum': '100',
                          'minimum': '2',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_group_home_dir',
            'description': 'Path to InnoDB log files',
            'name': 'innodb_log_group_home_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_flush_log_at_trx_commit',
            'description': 'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)',
            'name': 'innodb_flush_log_at_trx_commit',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb-safe-binlog',
            'deprecated': (5, 0, 3),
            'description': 'Truncates the binary log after last nonrolled-back transaction after InnoDB crash recovery',
            'name': 'innodb-safe-binlog',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': (((4, 1, 3),), ((4, 1), (5, 0)), ((5, 0, 3),))})),
      ( 'Various',
        ( { 'caption': 'innodb_fast_shutdown',
            'description': 'Speeds up the shutdown process of the InnoDB storage engine',
            'name': 'innodb_fast_shutdown',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_force_recovery',
            'description': 'Helps to save your data in case the disk image of the database becomes corrupt',
            'name': 'innodb_force_recovery',
            'values': ( { 'choice': [ '0',
                                      'SRV_FORCE_IGNORE_CORRUPT',
                                      'SRV_FORCE_NO_BACKGROUND',
                                      'SRV_FORCE_NO_TRX_UNDO',
                                      'SRV_FORCE_NO_IBUF_MERGE',
                                      'SRV_FORCE_NO_UNDO_LOG_SCAN',
                                      'SRV_FORCE_NO_LOG_REDO'],
                          'default': '0',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_use_native_aio',
            'description': 'Whether to disable asynchronous I/O subsystem',
            'name': 'innodb_use_native_aio',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_thread_concurrency',
            'description': 'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling',
            'name': 'innodb_thread_concurrency',
            'values': ( { 'default': '8',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '20',
                          'inversion': '5.0.9',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '5.0.19',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '0',
                          'inversion': '5.4.0',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '6.0.0',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_max_merged_io',
            'description': 'The maximum number of background I/O requests to merge to issue a larger I/O request',
            'name': 'innodb_max_merged_io',
            'values': ({ 'default': '64', 'type': 'numeric'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))},
          { 'caption': 'innodb_extra_dirty_writes',
            'description': 'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent',
            'name': 'innodb_extra_dirty_writes',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))},
          { 'caption': 'innodb_lock_wait_timeout',
            'description': 'Timeout in seconds an InnoDB transaction may wait for a lock before being rolled back',
            'name': 'innodb_lock_wait_timeout',
            'values': ( { 'default': '50',
                          'maximum': '1073741824',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_file_format_max',
            'description': 'The file format tag in the shared tablespace',
            'name': 'innodb_file_format_max',
            'values': ({ 'default': 'Antelope', 'type': 'string'},),
            'versions': (((5, 5, 5),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_purge_batch_size',
            'description': 'Specifies the number of InnoDB redo logs that trigger a purge operation.',
            'name': 'innodb_purge_batch_size',
            'values': ( { 'default': '20',
                          'maximum': '5000',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_purge_threads',
            'description': 'Specifies whether the InnoDB purge operation should be performed in a separate thread. By default, this operation is part of the InnoDB master thread.',
            'name': 'innodb_purge_threads',
            'values': ( { 'default': '0',
                          'maximum': '1',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_file_io_threads',
            'description': 'Number of file I/O threads in InnoDB',
            'name': 'innodb_file_io_threads',
            'values': ( { 'default': '4',
                          'maximum': '64',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'innodb_max_dirty_pages_pct',
            'description': 'Percentage of dirty pages allowed in bufferpool',
            'name': 'innodb_max_dirty_pages_pct',
            'values': ( { 'default': '90',
                          'maximum': '100',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '75',
                          'inversion': '5.4.0',
                          'maximum': '99',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '90',
                          'inversion': '6.0.0',
                          'maximum': '100',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_open_files',
            'description': 'The maximum number of files that InnoDB keeps open at the same time',
            'name': 'innodb_open_files',
            'values': ( { 'default': '300',
                          'maximum': '4294967295',
                          'minimum': '10',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_thread_concurrency_timer_based',
            'description': 'Whether to use the lock-free method of handling thread concurrency',
            'name': 'innodb_thread_concurrency_timer_based',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))})))),
  ( 'NDB Parameters',
    ( ( 'General',
        ( { 'caption': 'ndb-connectstring',
            'description': 'The management server that distributes the cluster configuration',
            'name': 'ndb-connectstring',
            'values': ({ 'type': 'string'},),
            'versions': ((), ((5, 1),), ())},
          { 'caption': 'ndb_report_thresh_binlog_mem_usage',
            'description': 'This is a threshold on the percentage of free memory remaining before reporting binlog status',
            'name': 'ndb_report_thresh_binlog_mem_usage',
            'values': ( { 'default': '10',
                          'maximum': '10',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'ndb-nodeid',
            'description': 'MySQL Cluster node ID for this MySQL server',
            'name': 'ndb-nodeid',
            'values': ( { 'inversion': '5.0.45',
                          'maximum': '63',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'inversion': '5.1.5',
                          'maximum': '255',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': (((5, 0, 45), (5, 1, 15)), ((5, 0), (5, 1)), ())},
          { 'caption': 'ndb_index_stat_enable',
            'description': 'Use NDB index statistics in query optimization',
            'name': 'ndb_index_stat_enable',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 19),))},
          { 'caption': 'ndb-mgmd-host',
            'description': 'Set the host (and port, if desired) for connecting to the management server',
            'name': 'ndb-mgmd-host',
            'values': ({ 'default': 'localhost:1186', 'type': 'string'},),
            'versions': ((), ((5, 0), (5, 1)), ())},
          { 'caption': 'skip-ndbcluster',
            'description': 'Disable the NDB Cluster storage engine',
            'name': 'skip-ndbcluster',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ((), ((5, 1), (6, 0)), ())},
          { 'caption': 'ndb-cluster-connection-pool',
            'description': 'The number of connections to the cluster used by MySQL',
            'name': 'ndb-cluster-connection-pool',
            'values': ( { 'default': '1',
                          'maximum': '63',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'ndb-wait-connected',
            'description': 'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections.',
            'name': 'ndb-wait-connected',
            'values': ( { 'default': '0',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 16),), ((5, 1),), ())},
          { 'caption': 'ndb_index_stat_update_freq',
            'description': 'How often to query data nodes instead of the statistics cache',
            'name': 'ndb_index_stat_update_freq',
            'values': ( { 'default': '20',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 14),))},
          { 'caption': 'ndb_cache_check_time',
            'description': 'The number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache',
            'name': 'ndb_cache_check_time',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb_log_empty_epochs',
            'description': 'When used, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables even when --log-slave-updates is enabled.',
            'name': 'ndb_log_empty_epochs',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 31), (5, 1, 31)), ((5, 1),), ())},
          { 'caption': 'ndb_extra_logging',
            'description': 'Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log',
            'name': 'ndb_extra_logging',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': (((5, 1, 6),), ((5, 1),), ())},
          { 'caption': 'ndb_optimized_node_selection',
            'description': 'Determines how an SQL node chooses a cluster data node to use as transaction coordinator',
            'name': 'ndb_optimized_node_selection',
            'values': ( { 'default': 'on',
                          'inversion': '4.1.9',
                          'off': 'off',
                          'on': 'on',
                          'outversion': '5.1.22-ndb-6.33',
                          'type': 'boolean'},
                        { 'default': '3',
                          'inversion': '5.1.22-ndb-6.3.4',
                          'maximum': '3',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((4, 1, 9),), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb_index_stat_cache_entries',
            'description': 'Sets the granularity of the statistics by determining the number of starting and ending keys',
            'name': 'ndb_index_stat_cache_entries',
            'values': ( { 'default': '32',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 14),))},
          { 'caption': 'ndb_use_transactions',
            'description': 'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query',
            'name': 'ndb_use_transactions',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 18),),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ())},
          { 'caption': 'ndb_force_send',
            'description': 'Forces sending of buffers to NDB immediately, without waiting for other threads',
            'name': 'ndb_force_send',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((4, 1, 8),), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndbcluster',
            'description': 'Enable NDB Cluster (if this version of MySQL supports it)',
            'disabledby': 'skip-ndbcluster',
            'name': 'ndbcluster',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb-wait-setup',
            'description': 'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete.',
            'name': 'ndb-wait-setup',
            'values': ( { 'default': '15',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 39), (5, 1, 39), (5, 1, 39)),
                          ((5, 1),),
                          ())},
          { 'caption': 'ndb-batch-size',
            'description': 'The size (in bytes) to use for NDB transaction batches',
            'name': 'ndb-batch-size',
            'values': ( { 'default': '32768',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 23),), ((5, 1),), ())},
          { 'caption': 'ndb-log-update-as-write',
            'description': 'Toggles logging of updates on the master between updates (OFF) and writes (ON)',
            'name': 'ndb-log-update-as-write',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19), (5, 1, 22)), ((5, 1),), ())},
          { 'caption': 'ndb_log_updated_only',
            'description': 'Log complete rows (ON) or updates only (OFF)',
            'name': 'ndb_log_updated_only',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'ndb_report_thresh_binlog_epoch_slip',
            'description': 'This is a threshold on the number of epochs to be behind before reporting binlog status',
            'name': 'ndb_report_thresh_binlog_epoch_slip',
            'values': ( { 'default': '3',
                          'maximum': '256',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'ndb_autoincrement_prefetch_sz',
            'description': 'NDB auto-increment prefetch size',
            'name': 'ndb_autoincrement_prefetch_sz',
            'values': ( { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.0.54',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.0.56',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22-ndb-6.2.9',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23-ndb-6.2.10',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22-ndb-6.3.6',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23-ndb-6.3.7',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.39-ndb-6.3.30',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.41-ndb-6.3.31',
                          'maximum': '65536',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.39-ndb-7.0.10',
                          'type': 'numeric'},
                        { 'default': '32',
                          'inversion': '5.1.41-ndb-7.0.11',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 8),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),)),
  ( 'Transactions',
    ( ( 'Misc',
        ( { 'caption': 'completion_type',
            'description': 'Default completion type',
            'name': 'completion_type',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '0',
                          'inversion': '5.0.3',
                          'outversion': '5.5.2',
                          'type': 'numeric'},
                        { 'choice': [ 'NO_CHAIN',
                                      'CHAIN',
                                      'RELEASE',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'NO_CHAIN',
                          'inversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': ['0', '1', '2'],
                          'default': '0',
                          'inversion': '6.0.0',
                          'outversion': '6.0.14',
                          'type': 'numeric'},
                        { 'choice': [ 'NO_CHAIN',
                                      'CHAIN',
                                      'RELEASE',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'NO_CHAIN',
                          'inversion': '6.0.14',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),)),
  ( 'Networking',
    ( ( 'General',
        ( { 'caption': 'socket',
            'description': 'Socket file to use for connection',
            'name': 'socket',
            'values': ( { 'default': '/tmp/mysql.sock',
                          'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( 'Data / Memory size',
        ( { 'caption': 'max_allowed_packet',
            'description': 'Max packetlength to send/receive from to server',
            'name': 'max_allowed_packet',
            'values': ( { 'default': '1048576',
                          'maximum': '1073741824',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'net_buffer_length',
            'description': 'Buffer length for TCP/IP and socket communication',
            'name': 'net_buffer_length',
            'values': ( { 'default': '16384',
                          'maximum': '1048576',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Timeout Settings',
        ( { 'caption': 'net_read_timeout',
            'description': 'Number of seconds to wait for more data from a connection before aborting the read',
            'name': 'net_read_timeout',
            'values': ( { 'default': '30',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'wait_timeout',
            'description': 'The number of seconds the server waits for activity on a connection before closing it',
            'name': 'wait_timeout',
            'values': ( { 'default': '28800',
                          'maximum': '31536000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '28800',
                          'maximum': '2147483',
                          'minimum': '1',
                          'platform': 'windows',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'net_write_timeout',
            'description': 'Number of seconds to wait for a block to be written to a connection before aborting the write',
            'name': 'net_write_timeout',
            'values': ( { 'default': '60',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'connect_timeout',
            'description': "The number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'",
            'name': 'connect_timeout',
            'values': ( { 'default': '5',
                          'minimum': '2',
                          'outversion': '5.0.51',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.0.52',
                          'type': 'numeric'},
                        { 'default': '5',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.1.23',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'interactive_timeout',
            'description': 'The number of seconds the server waits for activity on an interactive connection before closing it',
            'name': 'interactive_timeout',
            'values': ( { 'default': '28800',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Advanced',
        ( { 'caption': 'net_retry_count',
            'description': 'If a read on a communication port is interrupted, retry this many times before giving up',
            'name': 'net_retry_count',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_connections',
            'description': 'The number of simultaneous clients allowed',
            'name': 'max_connections',
            'values': ( { 'default': '100',
                          'outversion': '5.1.14',
                          'type': 'numeric'},
                        { 'default': '151',
                          'inversion': '5.1.15',
                          'maximum': '16384',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '151',
                          'inversion': '5.1.17',
                          'maximum': '100000',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_user_connections',
            'description': 'The maximum number of active connections for a single user (0 = no limit)',
            'name': 'max_user_connections',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_connect_errors',
            'description': 'If there is more than this number of interrupted connections from a host this host will be blocked from further connections',
            'name': 'max_connect_errors',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Naming',
        ( { 'caption': 'skip-name-resolve',
            'description': "Don't resolve host names. All host names are IPs or 'localhost'",
            'name': 'skip-name-resolve',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-host-cache',
            'description': "Don't cache host names",
            'name': 'skip-host-cache',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( 'Replication',
    ( ( 'General',
        ( { 'caption': 'server-id',
            'description': 'Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication.',
            'name': 'server-id',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( 'Master',
        ( { 'caption': 'show-slave-auth-info',
            'description': 'Show user name and password in SHOW SLAVE HOSTS on this master',
            'name': 'show-slave-auth-info',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'auto_increment_increment',
            'description': 'AUTO_INCREMENT columns are incremented by this value',
            'name': 'auto_increment_increment',
            'values': ( { 'default': '1',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'auto_increment_offset',
            'description': 'Offset added to AUTO_INCREMENT columns',
            'name': 'auto_increment_offset',
            'values': ( { 'default': '1',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'master-bind',
            'description': 'The network interface which is to be used for connecting to the master by a replication slave having multiple network connections',
            'name': 'master-bind',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 1, 22),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( 'General slave',
        ( { 'caption': 'slave-net-timeout',
            'description': 'Number of seconds to wait for more data from a master/slave connection before aborting the read',
            'name': 'slave-net-timeout',
            'values': ( { 'default': '3600',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'disconnect-slave-event-count',
            'description': 'Option used by mysql-test for debugging and testing of replication',
            'name': 'disconnect-slave-event-count',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'abort-slave-event-count',
            'description': 'Option used by mysql-test for debugging and testing of replication',
            'name': 'abort-slave-event-count',
            'values': ( { 'default': '0',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave-skip-errors',
            'description': 'Tells the slave thread to continue replication when a query returns an error from the provided list',
            'name': 'slave-skip-errors',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_allow_batching',
            'description': 'Turns update batching on and off for a replication slave',
            'name': 'slave_allow_batching',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'skip-slave-start',
            'description': 'If set, slave is not autostarted',
            'name': 'skip-slave-start',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_transaction_retries',
            'description': 'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping',
            'name': 'slave_transaction_retries',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 11), (5, 0, 3)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slave-updates',
            'description': 'This option tells the slave to log the updates performed by its SQL thread to its own binary log',
            'name': 'log-slave-updates',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave-load-tmpdir',
            'description': 'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE command',
            'name': 'slave-load-tmpdir',
            'values': ({ 'default': '/tmp', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_compressed_protocol',
            'description': 'Use compression on master/slave protocol',
            'name': 'slave_compressed_protocol',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Slave replication objects',
        ( { 'caption': 'replicate-ignore-db',
            'description': 'Tells the slave SQL thread not to replicate to the specified database',
            'name': 'replicate-ignore-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-wild-do-table',
            'description': 'Tells the slave thread to restrict replication to the tables that match the specified wildcard pattern',
            'name': 'replicate-wild-do-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-ignore-table',
            'description': 'Tells the slave SQL thread not to replicate to the specified table',
            'name': 'replicate-ignore-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-do-db',
            'description': 'Tells the slave SQL thread to restrict replication to the specified database',
            'name': 'replicate-do-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-do-table',
            'description': 'Tells the slave SQL thread to restrict replication to the specified table',
            'name': 'replicate-do-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-rewrite-db',
            'description': 'Updates to a database with a different name than the original',
            'name': 'replicate-rewrite-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-wild-ignore-table',
            'description': 'Tells the slave thread not to replicate to the tables that match the given wildcard pattern',
            'name': 'replicate-wild-ignore-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Slave Identification',
        ( { 'caption': 'report-port',
            'description': 'Port for connecting to slave reported to the master during slave registration',
            'name': 'report-port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-user',
            'description': 'The account name that a slave server should report to the master server',
            'name': 'report-user',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-host',
            'description': 'Host name or IP of the slave to be reported to the master during slave registration',
            'name': 'report-host',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-password',
            'description': 'The account password that a slave server should report to the master server',
            'name': 'report-password',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Relay Log',
        ( { 'caption': 'max_relay_log_size',
            'description': 'If nonzero, relay log will be rotated automatically when the size exceeds this value',
            'name': 'max_relay_log_size',
            'values': ( { 'default': '0',
                          'maximum': '1073741824',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay-log-info-file',
            'description': 'The location and name of the file that remembers where the SQL replication thread is in the relay logs',
            'name': 'relay-log-info-file',
            'optype': { 'format': 'relay-log-info-file=file_name'},
            'values': ( { 'default': 'relay-log.info',
                          'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay_log_space_limit',
            'description': 'Maximum space to use for all relay logs',
            'name': 'relay_log_space_limit',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay_log_purge',
            'description': 'Determines whether relay logs are purged',
            'name': 'relay_log_purge',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay-log-index',
            'description': 'The location and name to use for the file that keeps a list of the last relay logs',
            'name': 'relay-log-index',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay-log',
            'description': 'The location and base name to use for relay logs',
            'name': 'relay-log',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Slave default connection values',
        ( { 'caption': 'master-ssl-capath',
            'deprecated': (5, 1, 17),
            'description': 'Master SSL CA path. Only applies if you have enabled master-ssl',
            'name': 'master-ssl-capath',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-ca',
            'deprecated': (5, 1, 17),
            'description': 'Master SSL CA file. Only applies if you have enabled master-ssl',
            'name': 'master-ssl-ca',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-cert',
            'deprecated': (5, 1, 17),
            'description': 'Master SSL certificate file name. Only applies if you have enabled master-ssl',
            'name': 'master-ssl-cert',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-port',
            'deprecated': (5, 1, 17),
            'description': 'The port the master is listening on',
            'name': 'master-port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-cipher',
            'deprecated': (5, 1, 17),
            'description': 'Master SSL cipher. Only applies if you have enabled master-ssl',
            'name': 'master-ssl-cipher',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-host',
            'deprecated': (5, 1, 17),
            'description': 'Master host name or IP address for replication',
            'name': 'master-host',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-retry-count',
            'description': 'The number of tries the slave will make to connect to the master before giving up',
            'name': 'master-retry-count',
            'values': ( { 'bitsize': '32',
                          'default': '86400',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '86400',
                          'maximum': '18446744073709551615',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'master-connect-retry',
            'deprecated': (5, 1, 17),
            'description': 'The number of seconds the slave thread will sleep before retrying to connect to the master in case the master goes down or the connection is lost',
            'name': 'master-connect-retry',
            'values': ({ 'default': '60', 'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-user',
            'deprecated': (5, 1, 17),
            'description': 'The user name the slave thread will use for authentication when connecting to the master. The user must have FILE privilege. If the master user is not set, user test is assumed. The value in master.info will take precedence if it can be read',
            'name': 'master-user',
            'values': ({ 'default': 'test', 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-key',
            'deprecated': (5, 1, 17),
            'description': 'Master SSL keyfile name. Only applies if you have enabled master-ssl',
            'name': 'master-ssl-key',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl',
            'deprecated': (5, 1, 17),
            'description': 'Enable the slave to connect to the master using SSL',
            'name': 'master-ssl',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-password',
            'deprecated': (5, 1, 17),
            'description': 'The password the slave thread will authenticate with when connecting to the master',
            'name': 'master-password',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-info-file',
            'description': "The location and name of the file that remembers the master and where the I/O replication thread is in the master's binlogs",
            'name': 'master-info-file',
            'optype': { 'format': 'master-info-file=file_name'},
            'values': ({ 'default': 'master.info', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( 'Misc',
    ( ( 'Unsorted',
        ( { 'caption': 'exit-info',
            'description': 'Used for debugging; Use at your own risk!',
            'name': 'exit-info',
            'values': ({ 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_relay_log',
            'description': 'Synchronize relay log to disk after every #th event.',
            'name': 'sync_relay_log',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 10),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'mutex-deadlock-detector',
            'description': 'Enable detection of incorrect mutex usage',
            'name': 'mutex-deadlock-detector',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((6, 0, 9),), ((6, 0),), ())},
          { 'caption': 'enable-locking',
            'deprecated': (4, 0, 3),
            'description': 'Deprecated option, use --external-locking instead',
            'name': 'enable-locking',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'backup_elevation',
            'description': 'Enable or disable BACKUP DATABASE privilege elevation',
            'name': 'backup_elevation',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'sync_master_info',
            'description': 'Synchronize master.info to disk after every #th event.',
            'name': 'sync_master_info',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'restore_precheck',
            'description': 'Whether RESTORE performs privilege checking before restoring',
            'name': 'restore_precheck',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'multi_range_count',
            'description': 'The maximum number of ranges to send to a table handler at once during range selects',
            'name': 'multi_range_count',
            'values': ( { 'default': '256',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 3),),
                          ((5, 0), (5, 1), (5, 2)),
                          ((5, 2, 4), (6, 0, 3)))},
          { 'caption': 'large-pages',
            'description': 'Enable support for large pages',
            'name': 'large-pages',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'platform': 'linux',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_relay_log_info',
            'description': 'Synchronize relay.info file to disk after every #th event.',
            'name': 'sync_relay_log_info',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'restore_elevation',
            'description': 'Enable or disable RESTORE privilege elevation',
            'name': 'restore_elevation',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'backup_progress_log_file',
            'description': 'Name of the MySQL Backup progress log file',
            'name': 'backup_progress_log_file',
            'values': ( { 'default': 'backup_progress.log',
                          'type': 'filename'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'init_connect',
            'description': 'Statements that are executed for each new connection',
            'name': 'init_connect',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sql-bin-update-same',
            'description': 'The update log is deprecated since version 5.0, is replaced by the binary log and this option does nothing anymore',
            'name': 'sql-bin-update-same',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1),), ())},
          { 'caption': 'log-long-format',
            'deprecated': (4, 1),
            'description': 'Log some extra information to update log. Please note that this option is deprecated; see --log-short-format option',
            'name': 'log-long-format',
            'values': (),
            'versions': ((), ((4, 1),), ())},
          { 'caption': 'backup_progress_log',
            'description': 'Enable or disable MySQL Backup progress log',
            'name': 'backup_progress_log',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'backup_history_log',
            'description': 'Enable or disable MySQL Backup history log',
            'name': 'backup_history_log',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'debug',
            'description': 'Output debug log',
            'name': 'debug',
            'values': ( { 'default': "'d:t:o,/tmp/mysqld.trace'",
                          'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-backup-output',
            'description': 'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
            'name': 'log-backup-output',
            'values': ( { 'choice': ['TABLE', 'FILE', 'NONE'],
                          'default': 'TABLE',
                          'type': 'set'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'lc-messages',
            'description': 'The locale for error messages',
            'name': 'lc-messages',
            'values': ({ 'type': 'string'},),
            'versions': (((6, 0, 14),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'server-id-bits',
            'description': 'Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value.',
            'name': 'server-id-bits',
            'values': ( { 'default': '32',
                          'maximum': '32',
                          'minimum': '7',
                          'type': 'numeric'},),
            'versions': (((5, 1, 47), (5, 1, 47)), ((5, 1),), ())},
          { 'caption': 'div_precision_increment',
            'description': "Scale of the result of '/' operator will be increased by this many digits",
            'name': 'div_precision_increment',
            'values': ( { 'default': '4',
                          'maximum': '30',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 6),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'engine-condition-pushdown',
            'deprecated': (5, 5, 3),
            'description': 'Push supported query conditions to the storage engine',
            'name': 'engine-condition-pushdown',
            'values': ( { 'default': 'off',
                          'inversion': '5.0.3',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'on',
                          'inversion': '5.1.0',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'restore_disables_events',
            'description': 'Whether RESTORE disables restored events',
            'name': 'restore_disables_events',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'relay_log_recovery',
            'description': 'Enables automatic recovery of relay log files from master at startup',
            'name': 'relay_log_recovery',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'old-protocol',
            'description': 'Use old server behaviors',
            'name': 'old-protocol',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1),), ((4, 1, 1),))},
          { 'caption': 'join_cache_level',
            'description': 'How join buffers are used',
            'name': 'join_cache_level',
            'values': ( { 'default': '1',
                          'maximum': '8',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((6, 0, 9),), ((6, 0),), ((6, 0, 14),))},
          { 'caption': 'init_slave',
            'description': 'Command(s) that are executed when a slave connects to a master',
            'name': 'init_slave',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'table_lock_wait_timeout',
            'description': 'Currently unused',
            'name': 'table_lock_wait_timeout',
            'values': ( { 'default': '50',
                          'maximum': '1073741824',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 10),),
                          ((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                          ((5, 5, 3), (6, 0, 14)))},
          { 'caption': 'sync-bdb-logs',
            'deprecated': None,
            'description': 'Synchronously flush Berkeley DB logs. Enabled by default',
            'disabledby': 'skip-sync-bdb-logs',
            'name': 'sync-bdb-logs',
            'values': ( { 'default': 'true',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'lc-messages-dir',
            'description': 'The directory where error messages are located',
            'name': 'lc-messages-dir',
            'values': ({ 'type': 'dirname'},),
            'versions': (((6, 0, 14),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'backup_history_log_file',
            'description': 'Name of the MySQL Backup history log file',
            'name': 'backup_history_log_file',
            'values': ( { 'default': 'backup_history.log',
                          'type': 'filename'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'warnings',
            'deprecated': (5, 0),
            'description': 'Deprecated; use --log-warnings instead',
            'name': 'warnings',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'secure-backup-file-priv',
            'description': 'Limit BACKUP DATABASE and RESTORE to files in a single directory',
            'name': 'secure-backup-file-priv',
            'values': ({ 'type': 'string'},),
            'versions': (((6, 1, 11),), ((5, 6), (6, 0)), ())},
          { 'caption': 'lock_wait_timeout',
            'description': 'Timeout for metadata locks',
            'name': 'lock_wait_timeout',
            'values': ( { 'default': '31536000',
                          'maximum': '31536000',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'slave_type_conversions',
            'description': 'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.',
            'name': 'slave_type_conversions',
            'values': ( { 'choice': [ 'ALL_LOSSY',
                                      'ALL_NON_LOSSY',
                                      'ALL_LOSSY,ALL_NON_LOSSY'],
                          'default': '',
                          'type': 'string'},),
            'versions': ( ( (5, 1, 44),
                            (5, 1, 44),
                            (5, 1, 44),
                            (5, 5, 3),
                            (6, 0, 14)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'backupdir',
            'description': 'Default backup image file directory',
            'name': 'backupdir',
            'values': ({ 'type': 'filename'},),
            'versions': (((6, 0, 7),), ((5, 6), (6, 0)), ())},
          { 'caption': 'bootstrap',
            'description': 'Used by mysql installation scripts',
            'name': 'bootstrap',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'time_zone',
            'description': 'The current time zone.',
            'name': 'time_zone',
            'optype': { 'format': 'default_time_zone'},
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'event-scheduler',
            'description': 'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12',
            'name': 'event-scheduler',
            'values': ( { 'choice': ['ON', 'OFF', 'DISABLED'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 1, 6),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'record_buffer',
            'deprecated': (4, 0, 3),
            'description': 'Alias for read_buffer_size',
            'name': 'record_buffer',
            'optype': { 'outversion': '4.0.3'},
            'values': ( { 'default': '131072',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ((), (), ())},
          { 'caption': 'mysql-backup',
            'description': 'Enable MySQL Backup features',
            'name': 'mysql-backup',
            'values': (),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'optimizer_join_cache_level',
            'description': 'How join buffers are used',
            'name': 'optimizer_join_cache_level',
            'values': ( { 'default': '1',
                          'maximum': '8',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'set-variable',
            'deprecated': (5, 0),
            'description': 'Change the value of a variable; please note that this option is deprecated',
            'name': 'set-variable',
            'values': ({ 'type': 'string'},),
            'versions': ((), ((4, 1), (5, 0)), ())})),)))
