//
//  WBModelImageEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 19/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WBPluginEditorBase.h"

#include "wb_editor_image.h"


@interface ImageEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSImageView *imageView;
  IBOutlet NSButton *browseButton;
  IBOutlet NSTextField *widthField;
  IBOutlet NSTextField *heightField;  
  IBOutlet NSButton *resetSizeButton;
  IBOutlet NSButton *keepAspectRatio;
  
  ImageEditorBE *mBackEnd; //!< iamge editor backend
}

- (IBAction)browse:(id)sender;
- (IBAction)resetSize:(id)sender;
- (IBAction)setSize:(id)sender;
- (IBAction)toggleAspectRatio:(id)sender;

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;

@end
