#ifndef __LAYEREDITOR_H__
#define __LAYEREDITOR_H__

#include "wb_editor_layer.h"
#include "GrtTemplates.h"


#pragma make_public(::LayerEditorBE)

#ifdef _MSC_VER
using namespace MySQL::Grt;
using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
#endif

namespace MySQL {
namespace Grt {

public ref class LayerEditorBE : public BaseEditor
{
protected:
  LayerEditorBE(::LayerEditorBE *inn)
    : BaseEditor(inn)
  {}

public:
  LayerEditorBE::LayerEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
  : BaseEditor(
      new ::LayerEditorBE(grtm->get_unmanaged_object(), 
      workbench_physical_LayerRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
          )
      )
  {
  }

  ::LayerEditorBE *get_unmanaged_object()
  { return static_cast<::LayerEditorBE *>(inner); }

  void set_name(String ^name)
  {
    get_unmanaged_object()->set_name(NativeToCppString(name));
  }

  String^ get_name()
  {
    return CppStringToNative(get_unmanaged_object()->get_name());
  }

  void set_color(String ^color)
  {
    get_unmanaged_object()->set_color(NativeToCppString(color));
  }

  String^ get_color()
  {
    return CppStringToNative(get_unmanaged_object()->get_color());
  }
};

} // namespace Grt
} // namespace MySQL

#endif // __LAYEREDITOR_H__