#ifndef _ADDON_DOWNLOADER_H_
#define _ADDON_DOWNLOADER_H_


#include "addon_proc_net.h"


class Addon_downloader : public Addon_proc_net
{
public:
  Addon_downloader();
  virtual ~Addon_downloader();

  PROPERTY(Addon_repo *, installed_addons)
  PROPERTY(std::string, guid)
  PROPERTY(std::string, version)
  PROPERTY(bool, lookup_installed_addons)

private:
  virtual void do_ensure_valid_state(std::string &err);
  virtual void do_execute();
  void download(const std::string &guid, const std::string &min_ver, const std::string &max_ver, bool lookup_installed_addons);

  Addon_repo *_installed_addons;
  std::string _guid;
  std::string _version;
  bool _lookup_installed_addons;
};


#endif // _ADDON_DOWNLOADER_H_
