#ifndef _ADDON_INSTALLER_H_
#define _ADDON_INSTALLER_H_


#include "addon_proc.h"
#include "zip.h"


class Addon_installer : public Addon_proc
{
public:
  Addon_installer();
  virtual ~Addon_installer();

  PROPERTY(Addon_repo *, installed_addons)
  PROPERTY(File_dir, base_dir)
  PROPERTY(File_dir, data_dir)
  PROPERTY(File_dir, user_data_dir)
  PROPERTY(std::string, guid)
  PROPERTY(std::string, min_ver)
  PROPERTY(std::string, max_ver)
  PROPERTY(int, newly_installed_count)

private:
  virtual void do_ensure_valid_state(std::string &err);
  virtual void do_execute();
  void install(const std::string &guid, const std::string &min_ver, const std::string &max_ver);
  void extract(zip *zip_, File_dir_list &created_folders, File_list &created_files);
  void rollback(File_dir_list &created_folders, File_list &created_files);

  Addon_repo *_installed_addons;
  File_dir _base_dir;
  File_dir _data_dir;
  File_dir _user_data_dir;
  std::string _guid;
  std::string _min_ver;
  std::string _max_ver;
  int _newly_installed_count;
};


#endif // _ADDON_INSTALLER_H_
