#ifndef _LOGGER_H_
#define _LOGGER_H_


#include "util.h"


class Logger
{
public:
  static Logger * default_instance();

  Logger();
  virtual ~Logger();

  void push_info(const std::string &text);
  void push_warn(const std::string &text);
  void push_err(const std::string &text);
  void throw_err(const std::string &text);
  void throw_err();

  PROPERTY(bool, enabled)

  class Scope_disabler
  {
  public:
    Scope_disabler(Logger *logger) : _logger(logger), _enabled(_logger->enabled()) { _logger->enabled(false); }
    ~Scope_disabler() { _logger->enabled(_enabled); }
  private:
    Logger *_logger;
    bool _enabled;
  };

private:
  bool _enabled;

  virtual void do_push_info(const std::string &text);
  virtual void do_push_warn(const std::string &text);
  virtual void do_push_err(const std::string &text);
  virtual void do_throw_err(const std::string &text);
};


#endif // _LOGGER_H_
