#include "stdafx.h"

#include "grtpp.h"
#include "interfaces/plugin.h"

#define MODULE_VERSION "1.0.0"

static grt::ListRef<app_Plugin> get_database_plugins_info(grt::GRT *grt);


class WbUpdaterModuleImpl : public grt::ModuleImplBase, public PluginInterfaceImpl
{
public:
  WbUpdaterModuleImpl(grt::CPPModuleLoader *loader) : grt::ModuleImplBase(loader) {}

  DEFINE_INIT_MODULE(MODULE_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(WbUpdaterModuleImpl::getPluginInfo));

  virtual grt::ListRef<app_Plugin> getPluginInfo()
  {
    return get_database_plugins_info(get_grt());
  }
};


#ifdef _WIN32
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj->moduleName(windows_dll)
#elif defined(__APPLE__)
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj.moduleName(osx_dylib)
#else
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj.moduleName(linux_so)
#endif


static grt::ListRef<app_Plugin> get_database_plugins_info(grt::GRT *grt)
{
  grt::ListRef<app_Plugin> plugins(grt);
  
  {
    app_PluginRef plugin(grt);
    
    FRONTEND_LIBNAME(plugin,
                     ".\\wb.updater.wbp.fe.dll",
                     "",
                     "");
    plugin->pluginType("gui");
    plugin->moduleFunctionName("WBPluginUpdater");
    plugin->name("wb.plugin.updater");
    plugin->caption("Update WB through internet");
    plugin->groups().insert("Application/Workbench");

    plugins.insert(plugin);
  }

  {
    app_PluginRef plugin(grt);
    
    FRONTEND_LIBNAME(plugin,
                     ".\\wb.updater.wbp.fe.dll",
                     "",
                     "");
    plugin->pluginType("gui");
    plugin->moduleFunctionName("WBPluginAddonManager");
    plugin->name("wb.plugin.addon.manager");
    plugin->caption("Manage addons");
    plugin->groups().insert("Application/Workbench");

    plugins.insert(plugin);
  }

  return plugins;
}

GRT_MODULE_ENTRY_POINT(WbUpdaterModuleImpl);