/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef __SQLEDITORFORMWRAPPER_H__
#define __SQLEDITORFORMWRAPPER_H__

#include "sqlide/wb_sql_editor_form.h"

#include "db_sql_editor_history_wr.h"
#include "Overview.h"

using namespace Runtime::InteropServices; // Needed for the [Out] keyword.

namespace MySQL {
namespace GUI {
namespace Workbench {

public ref class SqlEditorFormWrapper : public UIForm
{
public:
  typedef ManagedRef<::SqlEditorForm> ^ Ref;
  SqlEditorFormWrapper(boost::shared_ptr<::SqlEditorForm> *ptr);
private:
  ::SqlEditorForm::Ref *_ref;
private:
  ~SqlEditorFormWrapper();

public:
  MySQL::Grt::ActionList ^action_list;

public:
  GrtManager ^ grt_manager() { return gcnew GrtManager((*_ref)->grt_manager()); }
  SqlEditorWrapper ^ sql_editor() { return Ref2Ptr_<::Sql_editor, SqlEditorWrapper>((*_ref)->active_sql_editor()); }
  SqlEditorWrapper ^ sql_editor(int index) { return Ref2Ptr_<::Sql_editor, SqlEditorWrapper>((*_ref)->sql_editor(index)); }
  int sql_editor_count() { return (*_ref)->sql_editor_count(); }
  String ^ sql_editor_caption(int index) { return CppStringToNative((*_ref)->sql_editor_caption(index)); }
  void sql_editor_caption(int index, String^ caption) { ((*_ref)->sql_editor_caption(index, NativeToCppString(caption))); }
  void new_sql_script_file() { (*_ref)->new_sql_script_file(); }
  void remove_sql_editor(int index) { return (*_ref)->remove_sql_editor(index); }
  int active_sql_editor_index() { return (*_ref)->active_sql_editor_index(); }
  void active_sql_editor_index(int val) { (*_ref)->active_sql_editor_index(val); }

  bool sql_editor_dirty(int index) { return (*_ref)->sql_editor_dirty(index); }
  bool sql_editor_reorder(int from, int to) { return (*_ref)->sql_editor_reorder((*_ref)->sql_editor(from), to); }
  bool sql_editor_is_scratch(int index) { return (*_ref)->sql_editor_is_scratch(index); }
  bool sql_editor_start_collapsed(int index) { return (*_ref)->sql_editor_start_collapsed(index); }
  void sql_editor_dirty(int index, bool flag) { (*_ref)->sql_editor_dirty(index, flag); }
  String^ sql_editor_path(int index) { return CppStringToNative((*_ref)->sql_editor_path(index)); }
  int sql_editor_index(SqlEditorWrapper^ editor) { return (*_ref)->sql_editor_index(*(Sql_editor::Ref*)(void*)~editor->ref()); };

  bool sql_editor_will_close(int index) { return (*_ref)->sql_editor_will_close(index); }

  void active_recordset(int editor, RecordsetWrapper ^val);

  String ^ caption() { return CppStringToNative((*_ref)->caption()); }
  int exec_sql_error_count() { return (*_ref)->exec_sql_error_count(); };

  void connect() { (*_ref)->connect(); }
  bool connected() { return (*_ref)->connected(); }
  void cancel_query() { (*_ref)->cancel_query(); }

  void reset() { (*_ref)->reset(); }
  void exec_sql(String ^sql, bool active_editor, bool wrap_with_non_std_delimiter) { (*_ref)->exec_sql(NativeToCppString(sql), !active_editor ? ::Sql_editor::Ref() : (*_ref)->active_sql_editor(), false, wrap_with_non_std_delimiter); }
  void commit() { (*_ref)->commit(); }
  void rollback() { (*_ref)->rollback(); }
  int recordset_count(int editor) { return (*_ref)->recordset_count(editor); }
  RecordsetWrapper ^ recordset(int editor, int index);

public:
  VarGridModelWrapper ^ log() { return _log; }
  System::Windows::Forms::ContextMenuStrip^ get_log_context_menu();
  DbSqlEditorHistoryWrapper ^ history() { return _history; }
  String ^ restore_sql_from_history(int entry_index, List<int> ^detail_indexes);
private:
  VarGridModelWrapper ^_log;
  DbSqlEditorHistoryWrapper ^_history;

public:
  void get_log_event_details(int log_event_no, [Out] int %log_event_type_code, [Out] String^ %log_event_time, [Out] String^ %log_event_action, [Out] String^ %log_event_message);

  String^ get_text_for_actions(List<NodeId^>^ indexes, bool query_only);
public:
  bool can_close() { return (*_ref)->can_close(); }

public:
  void active_schema(String ^schema) { (*_ref)->active_schema(NativeToCppString(schema)); }
  String ^ active_schema() { return CppStringToNative((*_ref)->active_schema()); }
  int active_schema_index() { return (*_ref)->active_schema_index(); }

public:
  GrtThreadedTask ^exec_sql_task;

private:
  RefreshUI ^_refresh_ui;
public:
  RefreshUI ^refresh_ui() { return _refresh_ui; }

  enum class PartialRefreshType
  {
    RefreshEditor             = ::SqlEditorForm::RefreshEditor, // refresh the text editor using data from backend
    RefreshEditorTitle        = ::SqlEditorForm::RefreshEditorTitle,
    RefreshRecordsetTitle     = ::SqlEditorForm::RefreshRecordsetTitle,
    RunCurrentScript          = ::SqlEditorForm::RunCurrentScript,
    RefreshMainTitle          = ::SqlEditorForm::RefreshMainTitle,

    RefreshEditorBackend      = ::SqlEditorForm::RefreshEditorBackend, // save text editor contents to backend so that it can be saved to file
    RunCurrentStatement       = ::SqlEditorForm::RunCurrentStatement, // run only statement under cursor position (if there any statement at all)
    ShowFindPanel             = ::SqlEditorForm::ShowFindPanel, // show the Find panel for the active editor
    ShowSpecialCharacters     = ::SqlEditorForm::ShowSpecialCharacters, // show special (tab, space, newline etc) in active editor
    HideSpecialCharacters     = ::SqlEditorForm::HideSpecialCharacters, // hide special chars
  };

public:
  Windows::Forms::Control^ get_sidebar_control();
  Windows::Forms::ToolStrip^ get_editor_toolbar(int index);
  Windows::Forms::Control^ get_palette_control();

  void set_tool_item_checked(String^ name, bool value);

public:
  typedef DelegateSlot3<void, void,
    int, int, ::Recordset::Ref, long long, bool, bool> Recordset_list_changed_cb;
  void recordset_list_changed_cb(Recordset_list_changed_cb::ManagedDelegate ^cb);
private:
  Recordset_list_changed_cb ^_recordset_list_changed_cb;

public:
  typedef DelegateSlot2<void, void, std::string, String^, bool, bool> Output_text_ui_cb;
  void output_text_ui_cb(Output_text_ui_cb::ManagedDelegate ^cb);
private:
  Output_text_ui_cb ^_output_text_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    int, int> Sql_editor_new_ui_cb;
  void sql_editor_new_ui_cb(Sql_editor_new_ui_cb::ManagedDelegate ^cb);
private:
  Sql_editor_new_ui_cb ^_sql_editor_new_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    std::string, String^> Sql_editor_text_insert_cb;
  void sql_editor_text_insert_cb(Sql_editor_text_insert_cb::ManagedDelegate ^cb);
private:
  Sql_editor_text_insert_cb ^_sql_editor_text_insert_cb;
};


};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __SQLEDITORFORMWRAPPER_H__
