//
//  MCollectionViewItemView.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 12/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MCollectionViewItemView : NSView 
{
@private
  NSCollectionViewItem* mOwner;
  NSPoint mMouseDownLocation;
  BOOL mIsEditing;
  
  BOOL mBecameFirstResponder;
@public
  IBOutlet id delegate;
}

- (void) setOwner: (NSCollectionViewItem*) owner;
- (NSCollectionViewItem*) owner;

- (NSCollectionView*) activeCollectionView;

- (void) setSelected: (BOOL) flag;
- (BOOL) selected;

- (id) delegate;
- (void) setDelegate: (id) delegate;

// Inline editing.
- (void) beginInlineEditing;
- (void) stopInlineEditing: (BOOL) accepted;
@end


@interface NSObject (MCollectionViewItemViewDelegate)
- (void) activateCollectionItem: (id) sender;
- (void) selectCollectionItem: (id) sender;
- (void) unselectCollectionItem: (id) sender;
- (void) clearSelection;
- (BOOL) isCollectionItemSelected: (id) sender;
- (BOOL) canRename: (id) sender;

- (BOOL) declareDragDataForItem: (id)sender
                     pasteboard: (NSPasteboard*)pasteboard;
- (NSArray*) dropTypesForItem: (id)sender;
- (BOOL) handleDroppedData: (id)data
                   forItem: (id)item;
@end

