/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>

@class MScintillaView;

#include "sqlide/sql_editor_be.h"
#include "base/string_utilities.h"

@interface MSQLEditorController : NSObject 
{
  IBOutlet MScintillaView* mScintillaView;

  NSTimer* mSqlCheckTimer;
  
  int mErrorCount;
  Sql_editor::Ref mBackEnd;
}

- (void)setEditorBackEnd:(const Sql_editor::Ref&)be;
- (Sql_editor::Ref)backEnd;

- (void)setView:(MScintillaView*)view;
- (MScintillaView*)view;

- (NSString*) currentSqlStatement; // SQL statement under current cursor position.
- (NSString*) string;              
- (NSString*) stringOrSelection;// Selected text only or entire editor contents (if no selection).
- (void)setString: (NSString*) string;
- (void)insertText: (NSString*) text;

@end
