/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>
#import "WBBasePanel.h"


#include "sqlide/wb_sql_editor_form.h"

@class ScintillaView;
@class MSQLEditorController;
@class MTogglePane;
@class MResultsetViewer;
@class MVerticalLayoutView;
@class MTabSwitcher;
@class WBSplitView;
@class WBSplitViewUnbrokenizerDelegate;
@class WBMiniToolbar;
@class GRTListDataSource;
@class WBQueryTab;

@interface WBSQLQueryPanel : WBBasePanel
{
  IBOutlet WBSplitView* mView;
  IBOutlet WBSplitView* mWorkView;
  IBOutlet WBSplitViewUnbrokenizerDelegate* mSplitterDelegate;
  
  IBOutlet NSSplitView* mSidebarSplit;
  
  IBOutlet WBMiniToolbar* mOutputToolbar;
  IBOutlet NSTabView* mOutputTabView;
  IBOutlet NSPopUpButton* mOutputSelector;
  IBOutlet NSTextView* mTextOutput;
  
  IBOutlet NSTableView* mMessagesTable;
  IBOutlet NSTableView* mHistoryTable;
  IBOutlet NSTableView* mHistoryDetailsTable;

  IBOutlet NSTabView* mUpperTabView;
  IBOutlet MTabSwitcher* mUpperTabSwitcher;
  
  
  NSView *mSchemataBarView;

  NSTimeInterval mLastClick;
  
  BOOL mQueryAreaOpen;
  BOOL mResultsAreaOpen;
  BOOL mInitialized;
  
  NSMutableArray *mEditors;
  
  SqlEditorForm::Ref mBackEnd;
  
  NSLock *mTextOutputLock;
  std::string mTextOutputBuffer;
  
  BOOL schematabarAtRight;
  
  CGFloat lastOutputAreaHeight;
  CGFloat lastSidebarWidth;
  CGFloat lastSchematabarWidth;
}

@property (readonly) SqlEditorForm::Ref backEnd;

- (IBAction)clearOutput:(id)sender;
- (IBAction)copyOutputEntry:(id)sender;
- (IBAction)handleMenuAction:(id)sender;

- (void)addEditor:(WBBasePanel*)editor;

- (void)executeQuery:(id)sender currentStatementOnly: (bool) currentStatementOnly;
- (id)initWithBE:(const SqlEditorForm::Ref&)be;
- (MSQLEditorController*)activeEditor;
- (WBQueryTab*)activeQueryTab;
- (WBQueryTab*)queryTabForBackEndIndex:(int)index;
- (void)addSQLEditorTabWithBackEndIndex:(int)index;
- (void)setRightSidebar:(BOOL)flag;
- (void)flushOutputBuffer;
@end


