/* 
 * Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#import "WBSQLQueryPanel.h"

#import "WBMainController.h"
#import "WBMainWindow.h"
#import "WBQueryTab.h"
#import "MResultsetViewer.h"

#include "workbench/wb_context_ui.h"

#import "WBSQLQueryUI.h"
#import "base/log.h"

DEFAULT_LOG_DOMAIN(DOMAIN_WQE_NATIVE)

static WBSQLQueryPanel *getQueryPanel(wb::WBContextUI *wbui)
{
  bec::UIForm *form= wbui->get_active_main_form();
  if (form)
  {
    id panel= (id)form->get_frontend_data();
    if (panel)
    {
      if ([panel isKindOfClass: [WBSQLQueryPanel class]])
        return (WBSQLQueryPanel*)panel;
    }
  }
  return nil;
}


static WBBasePanel *createQueryPanel(WBMainWindow *mainwin, boost::shared_ptr<bec::UIForm> form)
{
  SqlEditorForm::Ref editor= boost::dynamic_pointer_cast<SqlEditorForm>(form);
  
  if (!editor)
    throw std::logic_error("invalid backend object");

  return [[[WBSQLQueryPanel alloc] initWithBE: editor] autorelease];
}


void setupSQLQueryUI(WBMainController *main, WBMainWindow *mainwin, wb::WBContextUI *wbui)
{  
  log_debug("Setting up UI\n");
//  wbui->get_command_ui()->add_builtin_command("query.jump_to_placeholder", boost::bind(call_jump_to_placeholder, wbui), 
//                                              boost::bind(validate_jump_to_placeholder, wbui));
  
  // other commands in wb_context_sqlide.cpp

  [main registerFormPanelFactory:createQueryPanel forFormType: WB_MAIN_VIEW_DB_QUERY];
}

