
/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 MacTableEditorFKColumnsInformationSource
 
 @abstract
 The purpose of this class is to insulate the C++ data structures needed by the MySQL Table Editor.
 
 @ingroup
 MySQL Table Editor
 */



#import "MacTableEditorFKColumnsInformationSource.h"

#include "mysql_table_editor.h"



@implementation MacTableEditorFKColumnsInformationSource



- (BOOL) rowEnabled: (NSInteger) rowIndex;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");

  bec::FKConstraintColumnsListBE* fk_columns_be(mBackEnd->get_fks()->get_columns());
  const ::bec::NodeId& node = mBackEnd->get_fks()->get_node(rowIndex);
  const bool yn = fk_columns_be->get_column_is_fk(node);
  
  return (yn ? YES : NO);
}



- (void) setRow: (NSInteger) rowIndex
        enabled: (BOOL) yn;
{
  NSAssert(mBackEnd != nil, @"The mBackEnd must not be nil.");
  bec::FKConstraintColumnsListBE* fk_columns_be(mBackEnd->get_fks()->get_columns());
  const ::bec::NodeId& node = mBackEnd->get_fks()->get_node(rowIndex);
  fk_columns_be->set_column_is_fk(node, ( yn ? true : false ) );
}



- (id) initWithListModel: (bec::ListModel*) model
            tableBackEnd: (MySQLTableEditorBE*) tableBackend;
{
  self = [self initWithListModel: model];
  
  if (self != nil) {
    mBackEnd = tableBackend;
  }
  
  return self;
}



@end


