//
//  UserEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 23/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#include "wb_config.h"

#import "WBPluginEditorBase.h"

#include "grtdb/editor_user.h"

@class GRTTreeDataSource;

@interface DbMysqlUserEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView;
  
  IBOutlet NSTextField *nameText;
  IBOutlet NSSecureTextField *passwordText;
  
  IBOutlet NSTableView *assignedRoleTable;
  IBOutlet NSOutlineView *roleOutline;
  
  IBOutlet NSButton *addButton;
  IBOutlet NSButton *removeButton;
  
  IBOutlet NSTextView *commentText;
  
  IBOutlet GRTTreeDataSource *roleTreeDS;
  NSMutableArray *mAssignedRoles;
  
  NSTimer *mTimer;
  bec::UserEditorBE *mBackEnd;
}

- (IBAction)addRole:(id)sender;
- (IBAction)removeRole:(id)sender;

@end
