using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Grt.Db;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class DbMysqlRoutineEditor : ObjectEditorPlugin
  {
    #region Member Variables

    private MySQLRoutineEditorBE routineEditorBE { get { return Backend as MySQLRoutineEditorBE; } } 
    private DbObjectEditorPages dbObjectEditorPages;

    #endregion

    #region Constructors

    public DbMysqlRoutineEditor(GrtManager GrtManager, GrtValue GrtList)
      : base(new MySQLRoutineEditorBE(GrtManager, GrtList))
    {
      InitializeComponent();

      sqlEd = new SqlEditorHelper(GrtManager, panel2, sqlEditorParseLogCallback);

      InitializingControls = true;
      try
      {
        InitFormData();

        CallRefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }
      routineEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);
    }

    #endregion

    #region ObjectEditorPlugin Overrides

    public override bool ChangeGrtList(GrtManager GrtManager, GrtValue GrtList)
    {
      // Make sure the changes are stored
      sqlEd.Parse(false);

      InitializingControls = true;

      try
      {
        grtManager = GrtManager;
        grtList = GrtList;

        Backend = new MySQLRoutineEditorBE(GrtManager, GrtList);

        InitFormData();

        RefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }

      routineEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);

      Invalidate();

      return true;
    }

    #endregion

    #region Form implementation

    private void DbMysqlRoutineEditor_Load(object sender, EventArgs e)
    {
      ActiveControl = sqlEd.sqlEditor;
    }

    protected void InitFormData()
    {
      // Add privileges tab sheet
      if (dbObjectEditorPages != null)
        mainTabControl.TabPages.Remove(dbObjectEditorPages.PrivilegesTabPage);
      dbObjectEditorPages = new DbObjectEditorPages(grtManager, routineEditorBE);
      if (!IsEditingLiveObject)
        mainTabControl.TabPages.Add(dbObjectEditorPages.PrivilegesTabPage);
    }

    protected override void RefreshFormData()
    {
      nameTextBox.Text = routineEditorBE.get_name();
      TabText = nameTextBox.Text;

      if (sqlEd.sqlEditor.IsRefreshEnabled || sqlEd.EditorBE != routineEditorBE)
      {
        sqlEd.SetEditorBackend(routineEditorBE, routineEditorBE.set_sql);
        bool adjustCursorPos = String.IsNullOrEmpty(sqlEd.sqlEditor.SqlText);
        int caretPos;
        sqlEd.sqlEditor.SqlText = routineEditorBE.get_formatted_sql_for_editing(out caretPos);
        if (adjustCursorPos)
          sqlEd.sqlEditor.Selection.Start = sqlEd.sqlEditor.Selection.End = caretPos;
      }
      else if (sqlEd.sqlEditor.IsSqlCheckEnabled)
      {
        sqlEd.sqlEditor.CheckSql(false);
      }
    }

    private void sqlEditorParseLogCallback(List<String> strlist)
    {
    }

    #endregion

    private void undoItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.UndoRedo.Undo();
    }

    private void cutItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Cut();
    }

    private void copyItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Copy();
    }

    private void pasteItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Paste();
    }

    private void selectAllItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Selection.SelectAll();
    }

    private void redoItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.UndoRedo.Redo();
    }

    private void editorContextMenu_Opening(object sender, CancelEventArgs e)
    {
      // Enable/Disable menu items depending on the edit content.
      undoItem.Enabled = sqlEd.sqlEditor.UndoRedo.CanUndo;
      redoItem.Enabled = sqlEd.sqlEditor.UndoRedo.CanRedo;
      cutItem.Enabled = sqlEd.sqlEditor.Selection.Length > 0;
      copyItem.Enabled = sqlEd.sqlEditor.Selection.Length > 0;
      pasteItem.Enabled = sqlEd.sqlEditor.Clipboard.CanPaste;
      selectAllItem.Enabled = sqlEd.sqlEditor.TextLength > 0;
    }

  }
}