//
//  WbPhysicalLayerEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 17/Apr/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "WBPluginEditorBase.h"

#include "wb_editor_layer.h"



@interface PhysicalLayerEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView; // this editor has a single Tab, but we put in a TabView for homegeneity
  
  IBOutlet NSTextField *nameText;
  
  IBOutlet NSTextField *colorText;
  IBOutlet NSColorWell *colorWell;
  
  NSTimer *mColorCommitTimer;
  LayerEditorBE *mBackEnd; //!< layer editor backend
}

- (IBAction)changeColor:(id)sender;

- (id)initWithModule:(grt::Module*)module GRTManager:(bec::GRTManager*)grtm arguments:(const grt::BaseListRef&)args;

- (NSView*)dockableView;

@end
