/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef __VAR_GRID_MODEL_WR_H__
#define __VAR_GRID_MODEL_WR_H__


#include "sqlide/var_grid_model_be.h"
#include "GrtThreadedTask.h" // reference in stdafx.h is not enough because stdafx.h has subdir only effect


namespace MySQL {
namespace Grt {


public ref class VarGridModelWrapper : public MySQL::Grt::GridModel
{
public:
  typedef ManagedRef<::VarGridModel> ^ Ref;
  VarGridModelWrapper(Ref ref);
  VarGridModelWrapper(IntPtr nref_ptr);
  Ref ref() { return _ref; }
private:
  Ref _ref;
private:
  ~VarGridModelWrapper();

public:
  typedef DelegateSlot0<int, int> Refresh_ui_cb;
  void refresh_ui_cb(Refresh_ui_cb::ManagedDelegate ^cb);
private:
  Refresh_ui_cb ^_refresh_ui_cb;
};


};  // namespace Grt
};  // namespace MySQL


#endif // __VAR_GRID_MODEL_WR_H__
