//
//  MySQLRoutineGroupEditor.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 23/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "WBPluginEditorBase.h"
#include "mysql_routinegroup_editor.h"


@interface DbMysqlRoutineGroupEditor : WBPluginEditorBase {
  IBOutlet NSTabView *tabView;
  
  IBOutlet NSTextField *nameText;
  IBOutlet NSTableView *routineTable;
  IBOutlet NSTextView *commentText;
  
  IBOutlet MScintillaView *codeText;
  
  NSMutableArray *mRoutineArray;
  
  // Syntax error checking.
  NSTimer* mSyntaxCheckTimer;
  int mErrorCount;
  
  MySQLRoutineGroupEditorBE *mBackEnd;  
}

- (IBAction) removeItem: (id) sender;

// Setup for code editor and syntax checking.
- (void) setupEditor;
- (void) resetSyntaxErrors;
- (void) checkSyntax:(NSTimer*) timer;

@end
