using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Grt.Db;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class DbMysqlViewEditor : ObjectEditorPlugin
  {
    #region Member Variables

    private MySQLViewEditorBE viewEditorBE { get { return Backend as MySQLViewEditorBE; } } 
    private DbObjectEditorPages dbObjectEditorPages;

    #endregion

    #region Constructors

    public DbMysqlViewEditor(GrtManager GrtManager, GrtValue GrtList)
      : base(new MySQLViewEditorBE(GrtManager, GrtList))
    {
      InitializeComponent();

     sqlEd = new SqlEditorHelper(GrtManager, panel1, sqlEditorParseLogCallback);

      InitializingControls = true;
      try
      {
        InitFormData();

        CallRefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }
      viewEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);
    }


    #endregion

    #region ObjectEditorPlugin Overrides

    public override bool ChangeGrtList(GrtManager GrtManager, GrtValue GrtList)
    {
      // Make sure the changes are stored
      sqlEd.Parse(false);

      InitializingControls = true;

      try
      {
        grtManager = GrtManager;
        grtList = GrtList;

        Backend = new MySQLViewEditorBE(GrtManager, GrtList);

        InitFormData();

        RefreshFormData();
      }
      finally
      {
        InitializingControls = false;
      }

      viewEditorBE.add_refresh_ui_handler(RefreshFormDataInvoke);

      Invalidate();

      return true;
    }

    #endregion

    #region Form implementation

    private void DbMysqlViewEditor_Load(object sender, EventArgs e)
    {
      ActiveControl = sqlEd.sqlEditor;
    }

    protected void InitFormData()
    {
      // Add privileges tab sheet
      if (dbObjectEditorPages != null)
        mainTabControl.TabPages.Remove(dbObjectEditorPages.PrivilegesTabPage);
      dbObjectEditorPages = new DbObjectEditorPages(grtManager, viewEditorBE);
      if (!IsEditingLiveObject)
          mainTabControl.TabPages.Add(dbObjectEditorPages.PrivilegesTabPage);
      else
          mainTabControl.TabPages.Remove(commentsTabpage);
    }

    protected override void RefreshFormData()
    {
      nameTextBox.Text = viewEditorBE.get_name();
      TabText = nameTextBox.Text;
      commentTextBox.Text = viewEditorBE.get_comment();

      if (sqlEd.sqlEditor.IsRefreshEnabled || sqlEd.EditorBE != viewEditorBE)
      {
        sqlEd.SetEditorBackend(viewEditorBE, viewEditorBE.set_query);
        sqlEd.sqlEditor.SqlText = viewEditorBE.get_query();
      }
      else if (sqlEd.sqlEditor.IsSqlCheckEnabled)
      {
        sqlEd.sqlEditor.CheckSql(false);
      }
    }

    private void nameTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls && !nameTextBox.Text.Equals(viewEditorBE.get_name()))
        viewEditorBE.set_name(nameTextBox.Text);

      TabText = nameTextBox.Text;
    }

    private void commentTextBox_TextChanged(object sender, EventArgs e)
    {
      if (!InitializingControls && !commentTextBox.Text.Equals(viewEditorBE.get_comment()))
        viewEditorBE.set_comment(commentTextBox.Text);
    }

    private void sqlEditorParseLogCallback(List<String> messages)
    {
    }

    private void undoItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.UndoRedo.Undo();
    }

    private void cutItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Cut();
    }

    private void copyItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Copy();
    }

    private void pasteItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Clipboard.Paste();
    }

    private void selectAllItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.Selection.SelectAll();
    }

    private void redoItem_Click(object sender, EventArgs e)
    {
      sqlEd.sqlEditor.UndoRedo.Redo();
    }

    private void editorContextMenu_Opening(object sender, CancelEventArgs e)
    {
      // Enable/Disable menu items depending on the edit content.
      undoItem.Enabled = sqlEd.sqlEditor.UndoRedo.CanUndo;
      redoItem.Enabled = sqlEd.sqlEditor.UndoRedo.CanRedo;
      cutItem.Enabled = sqlEd.sqlEditor.Selection.Length > 0;
      copyItem.Enabled = sqlEd.sqlEditor.Selection.Length > 0;
      pasteItem.Enabled = sqlEd.sqlEditor.Clipboard.CanPaste;
      selectAllItem.Enabled = sqlEd.sqlEditor.TextLength > 0;
    }

    #endregion

  }
}