#ifndef __OBJECT_ROLES_BE_H__
#define __OBJECT_ROLES_BE_H__

#include "DBObjectEditorBE.h"
#include "GrtTemplates.h"
#include "grtdb/dbobject_roles.h"

#pragma make_public(::bec::ObjectRoleListBE)
#pragma make_public(::bec::ObjectPrivilegeListBE)

namespace MySQL {
namespace Grt {
namespace Db {

ref class ObjectPrivilegeListBE;

public ref class ObjectRoleListBE : public MySQL::Grt::ListModel
{
public:
  enum class Columns {
    Name = ::bec::ObjectRoleListBE::Name
  };

public:
  ObjectRoleListBE(DBObjectEditorBE^ editor)
    : MySQL::Grt::ListModel(new ::bec::ObjectRoleListBE(editor->get_unmanaged_object()))
  {}

  ~ObjectRoleListBE()
  {
    delete inner;
  }

  ::bec::ObjectRoleListBE *get_unmanaged_object()
  { return static_cast<::bec::ObjectRoleListBE *>(inner); }


  void add_role_for_privileges(GrtValue^ role)
  {
    get_unmanaged_object()->add_role_for_privileges(db_RoleRef::cast_from(role->get_unmanaged_object()));
  }

  void remove_role_from_privileges(GrtValue^ role)
  {
    get_unmanaged_object()->remove_role_from_privileges(db_RoleRef::cast_from(role->get_unmanaged_object()));
  }


  ObjectPrivilegeListBE^ get_privilege_list();

  void set_selected(NodeId^ node)
  {
    get_unmanaged_object()->select_role(*node->get_unmanaged_object());
  }
};



public ref class ObjectPrivilegeListBE : public MySQL::Grt::ListModel
{
public:
  enum class Columns {
    Enabled = ::bec::ObjectPrivilegeListBE::Enabled,
    Name = ::bec::ObjectPrivilegeListBE::Name
  };

public:
  ObjectPrivilegeListBE(::bec::ObjectPrivilegeListBE *inn)
    : MySQL::Grt::ListModel(inn)
  {}

  ::bec::ObjectPrivilegeListBE *get_unmanaged_object()
  { return static_cast<::bec::ObjectPrivilegeListBE *>(inner); }
};
} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __OBJECT_ROLES_BE_H__
