/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _STDAFX_H_
#define _STDAFX_H_

#pragma warning(disable: 4793)  // 'vararg' causes native code generation

#ifdef _WIN32
#define NOMINMAX
#define WIN32_LEAN_AND_MEAN 
#include <windows.h>
#include <algorithm>

#define snprintf _snprintf

#include  <vcclr.h> // .net interop helpers
#endif // _WIN32

#include <glib.h>
#include <string>
#include <vector>
#include <stdexcept>
#include <stdarg.h>
#include <algorithm>
#include <map>
#include <list>
#include <sstream>
#include <cctype>
#include <pcre.h>
#include <algorithm>
#include <boost/foreach.hpp>
#include <windows.h>
#include <boost/function.hpp>
#include <boost/signals2.hpp>

#define _USE_MATH_DEFINES
#include <math.h>

#include <gl/gl.h>
#include <cairo/cairo.h>
#include <cairo/cairo-pdf.h>
#include <cairo/cairo-ps.h>
#include <cairo/cairo-svg.h>

// project headers
#include <grtpp.h>
#include <mdc.h>

#include "grts/structs.app.h"
#include "grts/structs.db.h"
#include "grts/structs.db.mgmt.h"
#include "grts/structs.db.mysql.h"
#include "grts/structs.db.query.h"
#include "grts/structs.h"
#include "grts/structs.model.h"
#include "grts/structs.workbench.h"
#include "grts/structs.workbench.logical.h"
#include "grts/structs.workbench.model.h"
#include "grts/structs.workbench.model.reporting.h"
#include "grts/structs.workbench.physical.h"

#include "grti/plugin.h"
#include "grti/wb_model_reporting.h"
#include "grti/wbvalidation.h"

#include "Grt.h"
#include "GrtManager.h"
#include "GrtTemplates.h"
#include "DelegateWrapper.h"
#include "ModelWrappers.h"
#include "GrtThreadedTaskWrapper.h"
#include "ActionList.h"

// sqlide.wr
#include "var_grid_model_wr.h"
#include "recordset_wr.h"

#endif // _STDAFX_H_
