/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __BASE_EDITOR_H_
#define __BASE_EDITOR_H_

#include "grt/editor_base.h"
#include "GrtTemplates.h"
#include "DelegateWrapper.h"
#include "GrtManager.h"

using namespace System;
using namespace System::Collections::Generic;

using namespace MySQL::Base;

#pragma make_public(bec::BaseEditor)

namespace MySQL {
namespace Grt {

public ref class BaseEditor : public UIForm
{
protected:

  BaseEditor(::bec::BaseEditor *inn)
    : UIForm(inn)
  {}

  DelegateSlot0<void,void> ^refresh_ui_handler;
  DelegateSlot1<void,void,int,int> ^refresh_partial_ui_handler;

public:
  enum class PartialRefreshType {
    RefreshTextChanged = bec::BaseEditor::RefreshTextChanged,
  };

  void disable_auto_refresh() { ((::bec::BaseEditor*)inner)->block_auto_refresh(); }
  void enable_auto_refresh()  { ((::bec::BaseEditor*)inner)->unblock_auto_refresh(); }

  ::bec::BaseEditor *get_unmanaged_object()
  { return static_cast<::bec::BaseEditor *>(inner); }

  GrtValue^ get_object() 
  { return gcnew GrtValue(get_unmanaged_object()->get_object()); }

  String^ get_title()
  { return CppStringToNativeRaw(get_unmanaged_object()->get_title()); }

  bool is_editing_live_object()
  { return get_unmanaged_object()->is_editing_live_object(); }

  void apply_changes_to_live_object()
  { get_unmanaged_object()->apply_changes_to_live_object(); }

  void refresh_live_object()
  { get_unmanaged_object()->refresh_live_object(); }

  void set_refresh_ui_handler(DelegateSlot0<void,void>::ManagedDelegate^ slot)
  {
    refresh_ui_handler= gcnew DelegateSlot0<void,void>(slot);
    get_unmanaged_object()->set_refresh_ui_slot(refresh_ui_handler->get_slot());
  }

  void set_refresh_partial_ui_handler(DelegateSlot1<void,void,int,int>::ManagedDelegate^ slot)
  {
    refresh_partial_ui_handler= gcnew DelegateSlot1<void,void,int,int>(slot);
    get_unmanaged_object()->set_partial_refresh_ui_slot(refresh_partial_ui_handler->get_slot());
  }

  GRT^ get_grt() { return gcnew GRT(get_unmanaged_object()->get_grt()); }

  GrtManager^ get_grt_manager() { return gcnew GrtManager(get_unmanaged_object()->get_grt_manager()); }

  // for use by subclasses
  void show_exception(String ^title, String ^detail)
  {
    MessageBox::Show(String::Format("An error has occurred while performing the requested action:\n{0}", detail),
      title, MessageBoxButtons::OK, MessageBoxIcon::Error);
  }

 // Db::Sql::SqlEditorWrapper^ get_sql_editor() { return Ref2Ptr<::Sql_editor, Db::Sql::SqlEditorWrapper>(get_unmanaged_object()->get_sql_editor()); }

  void show_validation_error(String ^title, String ^reason)
  {
    MessageBox::Show(String::Format("Cannot change property:\n{0}", reason), 
      title, MessageBoxButtons::OK, MessageBoxIcon::Error);
  }

  bool should_close_on_delete_of(String ^oid)
  {
    return get_unmanaged_object()->should_close_on_delete_of(NativeToCppString(oid));
  }

  bool is_editor_dirty()
  {
    return get_unmanaged_object()->is_editor_dirty();
  }
};


} // namespace Grt
} // namespace MySQL

#endif // __BASE_EDITOR_H_
