/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "Grt.h"
#include "TableEditorWrapper.h"

namespace MySQL {
namespace Grt {
namespace Db {

TableColumnsListWrapper::TableColumnsListWrapper(bec::TableColumnsListBE *inn)
  : ListModel(inn)
{}

void TableColumnsListWrapper::reorder_many(List<int> ^rows, int nindex)
{
  std::vector<int> nlist;

  for (int i= 0; i < rows->Count; i++)
    nlist.push_back(rows[i]);

  get_unmanaged_object()->reorder_many(nlist, nindex);
}

bool TableColumnsListWrapper::get_row(NodeId^ node,
             [Out] String^ %name,
             [Out] String^ %type,
             [Out] bool^ %ispk,
             [Out] bool^ %notnull,
             [Out] bool^ %unique,
             [Out] bool^ %isbinary,
             [Out] bool^ %isunsigned,
             [Out] bool^ %iszerofill,
             [Out] String^ %flags,
             [Out] String^ %defvalue,
             [Out] String^ %charset,
             [Out] String^ %collation,
             [Out] String^ %comment)
{
  std::string name_str= NativeToCppString(name);
  std::string type_str= NativeToCppString(type);
  std::string flags_str= NativeToCppString(flags);
  std::string defvalue_str= NativeToCppString(defvalue);
  std::string charset_str= NativeToCppString(charset);
  std::string collation_str= NativeToCppString(collation);
  std::string comment_str= NativeToCppString(comment);

  bool local_ispk;
  bool local_notnull;
  bool local_unique;
  bool local_isbinary;
  bool local_isunsigned;
  bool local_iszerofill;

  bool retval= get_unmanaged_object()->get_row(*node->get_unmanaged_object(), 
    name_str, 
    type_str, 
    local_ispk, 
    local_notnull, 
    local_unique, 
    local_isbinary,
    local_isunsigned,
    local_iszerofill,
    flags_str, 
    defvalue_str, 
    charset_str, 
    collation_str,
    comment_str);

  *ispk= local_ispk;
  *notnull= local_notnull;
  *unique= local_unique;
  *isbinary= local_isbinary;
  *isunsigned= local_isunsigned;
  *iszerofill= local_iszerofill;

  name= CppStringToNative(name_str);
  type= CppStringToNative(type_str);
  flags= CppStringToNative(flags_str);
  defvalue= CppStringToNative(defvalue_str);
  charset= CppStringToNative(charset_str);
  collation= CppStringToNative(collation_str);
  comment= CppStringToNative(comment_str);

  return retval;
}

IndexColumnsListWrapper::IndexColumnsListWrapper(IndexListWrapper^ owner)
  : ListModel(new bec::IndexColumnsListBE(owner->get_unmanaged_object()))
{}

IndexColumnsListWrapper::IndexColumnsListWrapper(bec::IndexColumnsListBE *inn)
  : ListModel(inn)
{}

void IndexColumnsListWrapper::set_column_enabled(NodeId^ node, bool flag)
{
 get_unmanaged_object()->set_column_enabled(*node->get_unmanaged_object(), flag); 
}

bool IndexColumnsListWrapper::get_column_enabled(NodeId^ node)
{
  return get_unmanaged_object()->get_column_enabled(*node->get_unmanaged_object()); 
}

int IndexColumnsListWrapper::get_max_order_index()
{
  return get_unmanaged_object()->get_max_order_index();
}


IndexListWrapper::IndexListWrapper(TableEditorWrapper^ owner)
  : ListModel(new bec::IndexListBE(owner->get_unmanaged_object()))
{}

IndexListWrapper::IndexListWrapper(bec::IndexListBE *inn)
  : ListModel(inn)
{}
  
IndexColumnsListWrapper^ IndexListWrapper::get_columns() 
{ return gcnew IndexColumnsListWrapper(get_unmanaged_object()->get_columns()); }

void IndexListWrapper::select_index(NodeId^ node)
{ get_unmanaged_object()->select_index(*node->get_unmanaged_object()); }

FKConstraintColumnsListWrapper::FKConstraintColumnsListWrapper(FKConstraintListWrapper^ owner)
  : ListModel(new bec::FKConstraintColumnsListBE(owner->get_unmanaged_object()))
{}

FKConstraintColumnsListWrapper::FKConstraintColumnsListWrapper(bec::FKConstraintColumnsListBE *inn)
  : ListModel(inn)
{}

List<String^>^ FKConstraintColumnsListWrapper::get_ref_columns_list(NodeId^ node, bool filtered)
{
  return CppStringListToNative(
    static_cast<bec::FKConstraintColumnsListBE *>(inner)->get_ref_columns_list(*node->get_unmanaged_object(), filtered));
}

bool FKConstraintColumnsListWrapper::set_column_is_fk(NodeId^ node, bool flag)
{
  return get_unmanaged_object()->set_column_is_fk(*node->get_unmanaged_object(), flag); 
}

bool FKConstraintColumnsListWrapper::get_column_is_fk(NodeId^ node)
{
  return get_unmanaged_object()->get_column_is_fk(*node->get_unmanaged_object()); 
}

FKConstraintListWrapper::FKConstraintListWrapper(TableEditorWrapper^ owner)
  : ListModel(new bec::FKConstraintListBE(owner->get_unmanaged_object()))
{}

FKConstraintListWrapper::FKConstraintListWrapper(bec::FKConstraintListBE *inn)
  : ListModel(inn)
{}

/*
NodeId^ FKConstraintListWrapper::add_column(String^ column_name)
{ return gcnew NodeId(&get_unmanaged_object()->add_column(NativeToCppString(column_name))); }*/

void FKConstraintListWrapper::select_fk(NodeId^ node)
{ get_unmanaged_object()->select_fk(*node->get_unmanaged_object()); }


FKConstraintColumnsListWrapper^ FKConstraintListWrapper::get_columns()
{ return gcnew FKConstraintColumnsListWrapper(get_unmanaged_object()->get_columns()); }



IndexListWrapper^ TableEditorWrapper::get_indexes() 
{ return gcnew IndexListWrapper(get_unmanaged_object()->get_indexes()); }

FKConstraintListWrapper^ TableEditorWrapper::get_fks() 
{ return gcnew FKConstraintListWrapper(get_unmanaged_object()->get_fks()); }


// table options
//...

// column editing
NodeId^ TableEditorWrapper::add_column(String^ name)
{ return gcnew NodeId(&get_unmanaged_object()->add_column(NativeToCppString(name))); }

void TableEditorWrapper::remove_column(NodeId^ node)
{ get_unmanaged_object()->remove_column(*node->get_unmanaged_object()); }

//db_Column get_column_with_name(const std::string &name);

// fk editing
NodeId^ TableEditorWrapper::add_fk(String^ name)
{
  return gcnew NodeId(&get_unmanaged_object()->add_fk(NativeToCppString(name)));
}

void TableEditorWrapper::remove_fk(NodeId^ node)
{ get_unmanaged_object()->remove_fk(*node->get_unmanaged_object()); }

NodeId^ TableEditorWrapper::add_fk_with_columns(List<NodeId ^> ^columns)
{
  std::vector<bec::NodeId> node_vec= ObjectListToCppVector<NodeId, bec::NodeId>(columns);
  return gcnew NodeId(&get_unmanaged_object()->add_fk_with_columns(node_vec));
}

// index editing
NodeId^ TableEditorWrapper::add_index(String^ name)
{ return gcnew NodeId(&get_unmanaged_object()->add_index(NativeToCppString(name))); }

void TableEditorWrapper::remove_index(NodeId^ node)
{ get_unmanaged_object()->remove_index(*node->get_unmanaged_object()); }

NodeId^ TableEditorWrapper::add_index_with_columns(List<NodeId ^> ^columns)
{
  std::vector<bec::NodeId> node_vec= ObjectListToCppVector<NodeId, bec::NodeId>(columns);
  return gcnew NodeId(&get_unmanaged_object()->add_index_with_columns(node_vec));
}

List<String^>^ TableEditorWrapper::get_index_types()
{  
  return CppStringListToNative(
    static_cast<bec::TableEditorBE *>(inner)->get_index_types());
}


} // namespace Db
} // namespace Grt
} // namespace MySQL
