#ifndef __VIEW_EDITOR_H__
#define __VIEW_EDITOR_H__

#include "DBObjectEditorBE.h"
#include "GrtTemplates.h"
#include "grtdb/editor_view.h"

namespace MySQL {
namespace Grt {
namespace Db {

public ref class ViewEditorBE : public DBObjectEditorBE
{
protected:
  ViewEditorBE(::bec::ViewEditorBE *inn)
    : DBObjectEditorBE(inn)
  {}

public:
  //virtual db_DatabaseObject get_dbobject() { return get_View(); }
  //virtual db_View get_View()= 0;

  ::bec::ViewEditorBE *get_unmanaged_object()
  { return static_cast<::bec::ViewEditorBE *>(inner); }

  String^ get_query()
  { return CppStringToNative(get_unmanaged_object()->get_query()); }

  void set_query(String ^query, bool sync)
  { get_unmanaged_object()->set_query(NativeToCppString(query), sync); }

  bool has_syntax_error() { return get_unmanaged_object()->has_syntax_error(); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __VIEW_EDITOR_H__