/* 
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#import <Cocoa/Cocoa.h>

#import "MFBase.h"


/** MForms control implementations must subclass their own NS counterpart and implement the methods
 * below.  
 */
@interface NSView(MForms)

- (id)innerView;

- (void)subviewMinimumSizeChanged;
- (NSSize)minimumSize;
- (NSSize)minimumSizeForWidth:(float)width;
- (NSSize)preferredSize;
- (NSSize)preferredSizeForWidth:(float)width;

- (void)setFixedFrameSize:(NSSize)size;
- (NSSize)fixedFrameSize;
- (BOOL)widthIsFixed;
- (BOOL)heightIsFixed;

// Tag is used for internal purposes (special flags), do not use it for anything else
- (void)setTag:(NSInteger)tag;

- (void)destroy;

- (void)drawBounds:(NSRect)rect;
@end

namespace mforms { class View; }
NSView *nsviewForView(mforms::View *view);
