#include <stdarg.h>
#include <stdio.h>
#include <errno.h>
#include "internals.h"
#include "setjmp.h"
#include "signal_internals.h"
#include "mutex.h"

#if defined(DEBUG) || defined(IO_DEBUG) || defined(TIMER_DEBUG) || defined(MUTEX_DEBUG)
void kprintf(const char* format, ...)

{
    va_list ap;
    int x;
    static char buf[1024];

    x = errno; 
    sprintf(buf, "%lx => ", mac_pthread_self());
#if defined(IO)
#if defined(SOLARIS)
    WRITE(2,buf,strlen(buf)); 
#else
    pthread_sys_write(2,buf,strlen(buf)); 
#endif
#else
    write(2,buf,strlen(buf));
#endif
    va_start(ap, format); 
    vsprintf(buf,format,ap);
#if defined(IO) 
#if defined(SOLARIS)
    WRITE(2,buf,strlen(buf)); 
#else
    pthread_sys_write(2,buf,strlen(buf)); 
#endif
#else
    write(2,buf,strlen(buf)); 
#endif
    errno = x;
}

dumpcontext(context)
#if defined (__FreeBSD__) || defined (_M_UNIX) || defined(__linux__) || defined(__dos__)
SYS_SIGJMP_BUF context;
#else
sigjmp_buf context;
#endif

{
    kprintf("{bp=%08lx sp=%08lx pc=%08lx}\n",
            context[JB_BP],
            context[JB_SP],
            context[JB_PC]);
}

dumpthread(p)
pthread_t p;

{
    kprintf("struct %08lx {\n", p); 
    kprintf("\tcontext=");
    dumpcontext(p->context);
    kprintf("\tbody=");
    dumpcontext(p->context);
    kprintf("\terrno=%d\n", p->errno);
    kprintf("\tret=%d\n", p->ret);
    kprintf("\tstack_base=%08lx\n", p->stack_base);
    kprintf("\tstate=%08lx\n", p->state);
    kprintf("\tsig=%d\n", p->sig);
    kprintf("\tosp=%08lx\n", p->osp);
    kprintf("\topc=%08lx\n", p->opc);
    kprintf("\tobp=%08lx\n", p->obp);
    kprintf("\tcond=%08lx\n", p->cond);
    kprintf("\tqueue=%08lx\n", p->queue);
    kprintf("\n");
}

void dumpqueue(q, index)
     pthread_queue_t q;
     int index;

{
  pthread_t next = q->head;
  timer_ent_t tmr;
  struct timeval now;

  while (next != NO_PTHREAD) {
    dumpthread(next);
    next = next->next[index];
  }
}

void dumpthreads()

{
  pthread_t p;
  for(p = all.head; p; p = p->next[ALL_QUEUE]) {
    dumpthread(p);
  }
}
#endif /* DEBUG || IO_DEBUG || TIMER_DEBUG || MUTEX_DEBUG */
