""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""
import sys
import os
from time import *

class LOG:
	def __init__(self, logfile = '/dev/null'):
		self.logfile = logfile
		self.output = None
		
	def log(self, errortype, msg):
		if not self.output:
			self.output = open(self.logfile,'a+')
			self.message("opening logfile %s" % self.logfile)
			
		message = errortype + ':' + sys.argv[0] + ':' + strftime("%d-%m-%Y",localtime(time())) + ':' + msg
		sys.stderr.write("%s\n" % message)
		self.output.write("%s\n" % message)
		
	def warning(self, message):
		self.log('WARNING',message)
		
	def error(self, message):
		self.log('ERROR',message)
		sys.exit(2)
		
	def message(self, message):
		self.log('MESSAGE',message)

	def flush(self):
		if self.output: self.output.flush()
