.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE USER" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE USER \- Creates a new database user
.SH SYNOPSIS
.sp
.nf
CREATE USER \fIusername\fR
    [ WITH
     [ SYSID \fIuid\fR ]
     [ PASSWORD '\fIpassword\fR' ] ]
    [ CREATEDB   | NOCREATEDB ] [ CREATEUSER | NOCREATEUSER ]
    [ IN GROUP     \fIgroupname\fR [, ...] ]
    [ VALID UNTIL  '\fIabstime\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIusername\fB\fR
The name of the user.
.TP
\fB\fIuid\fB\fR
The SYSID clause can be used to choose
the Postgres user id of the user
that is being created. It is not at all necessary that those
match the UNIX user ids, but some people
choose to keep the numbers the same.

If this is not specified, the highest assigned user id plus one
will be used as default.
.TP
\fB\fIpassword\fB\fR
Sets the user's password. If you do not plan to use password
authentication you can omit this option, otherwise the user
won't be able to connect to a password-authenticated server.
See the chapter on client authentication in the
\fIAdministrator's Guide\fR for details on
how to set up authentication mechanisms.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases.
If CREATEDB is specified, the user being defined will
be allowed to create his own databases. Using NOCREATEDB
will deny a user the ability to create databases. If this
clause is omitted, NOCREATEDB is used by default.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new users himself. This option will also make the user
a superuser who can override all access restrictions.
Omitting this clause will set the user's value of this
attribute to be NOCREATEUSER.
.TP
\fB\fIgroupname\fB\fR
A name of a group into which to insert the user as a new member.
.TP
\fB\fIabstime\fB\fR
The VALID UNTIL clause sets an absolute time after which the
user's password is no longer valid. 
If this clause is omitted the login will be valid for all time.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE USER\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
CREATE USER will add a new user to an instance of 
Postgres. Refer to the administrator's
guide for information about managing users and authentication.
You must be a database superuser to use this command.
.PP
Use ALTER USER [\fBalter_user\fR(l)]
to change a user's password and privileges, and DROP USER [\fBdrop_user\fR(l)] to remove a user.
Use \fBALTER GROUP\fR to add or remove the user from other groups.
Postgres
comes with a script createuser [\fBcreateuser\fR(1)]
which has the same functionality as this command (in fact, it calls this command)
but can be run from the command shell.
.SH "USAGE"
.PP
Create a user with no password:
.sp
.nf
CREATE USER jonathan
.sp
.fi
.PP
Create a user with a password:
.sp
.nf
CREATE USER davide WITH PASSWORD 'jw8s0F4'
.sp
.fi
.PP
Create a user with a password, whose account is valid until the end of 2001.
Note that after one second has ticked in 2002, the account is not
valid:
.sp
.nf
CREATE USER miriam WITH PASSWORD 'jw8s0F4' VALID UNTIL 'Jan 1 2002'
.sp
.fi
.PP
Create an account where the user can create databases:
.sp
.nf
CREATE USER manuel WITH PASSWORD 'jw8s0F4' CREATEDB
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE USER\fR statement in SQL92.
