/* $Id: gethostname.c,v 1.1.1.1 2001/08/21 14:46:29 postgres Exp $ */

#include <sys/types.h>
#include <string.h>

#include <sys/utsname.h>

#include "config.h"

int
gethostname(char *name, int namelen)
{
	static struct utsname mname;
	static int	called = 0;

	if (!called)
	{
		called++;
		uname(&mname);
	}
	strncpy(name, mname.nodename, (SYS_NMLN < namelen ? SYS_NMLN : namelen));

	return 0;
}
