<?php

/**************************************************
Program name:	servlist.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	List of Servers
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

session_start();
include ("$PATH_INCLUDE"."pre.inc.php");
include ("$PATH_INCLUDE"."links.inc.php");

//#$sql_get_version is SQL string to get version 
$sql_get = "SELECT version()";

// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");

# get array of servers
if (count($cfgServers) > 1) {
	# Loop through cfgServers array to get name of host:port for each server
	reset($cfgServers);
	while(list($key, $val) = each($cfgServers)) {

		if ($val['local'] || !empty($val['host'])) {
			unset($host_display);
			if ($val['local']) {
				$host_display .= "local:" . $val['port'];
			} else {
				if (!empty($val['host'])) {
					$host_display .= $val['host'];
				}
				if (!empty($val['port'])) {
					$host_display .= ":" . $val['port'];
				}	
			}
			$aryServers[$host_display] = $key;
		}
	}

}

$num_rows = count($aryServers);
$num_columns = 4;

for ($i = 1; $i < ($num_rows + 1); $i++) {
	$j = $i - 1;
	$sql_array[$j][2] = bool_YesNo($cfgServers[$i]['local']);
#	$sql_array[$j][0] = $cfgServers[$i]['host'];
	$sql_array[$j][0] = "<a class=link href=dblist.php?nserver=".$cfgServers[$i]['host'].">".$cfgServers[$i]['host']."</a>";
	$sql_array[$j][1] = $cfgServers[$i]['port'];
	$sql_array[$j][3] = bool_YesNo($cfgServers[$i]['adv_auth']);
}

#column names
$column_name[0] = $strHost;
$column_name[1] = $strPort;
$column_name[2] = $strLocal;
$column_name[3] = $strLoginRequired;

$cfgBrowseLink = "<a class=link href=sqlresults.php?action=tbl_browse>".$strBrowse."</a>";

// $web_page is template page that is displayed.
$web_page = webpage($PHP_SELF);


// Display Page
include($PATH_TEMPLATE.$cfgTemplate1);


?>
