<?
/**************************************************
File name:	tbl_privilege2.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Grant or Revoke privileges.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

session_start();
include ("$PATH_INCLUDE"."pre.inc.php");
include ($PATH_INCLUDE . "links.inc.php");

// Build array of table indexes.  Returns $table_indexes_array
include ($PATH_INCLUDE."get_table_privilege.inc.php");

#echo "action".$action;
$arrPrivileges = array('select', 'insert', 'update', 'rule');
$arrAcl        = array('r',      'a',      'w',      'R');

// Page Title
if ($todo == "revoke") {
	$strPageTitle = $strPageTitle_tbl_privilege2_revoke;
} else {
	$strPageTitle = $strPageTitle_tbl_privilege2_grant;
}

// Check boxes
	$i = 0;
	while ($p = $arrPrivileges[$i]) {
#		echo "p - ".$p."<br>";
		$cb_priv[$p] = '<input type="checkbox" name="privileges[]" value="'. "$p\"> ". ucfirst($p) ."</input>";
		$i++;
	}

// Default variables (for all todo but revoke)
	$Expected = $strYes;
	$todolabel = "Grant";
	$strToFrom = "to";

// SWITCH depending on action
	switch ($todo) {
		case "revoke":
			$Expected =  $strNo;
			$todolabel = "Revoke";
			$strToFrom = "from";
			break;	

		case "grant":
			break;

		case "grantuser":
			include($PATH_INCLUDE."get_array_users.inc.php");
			break;

		case "grantgroup":
			include($PATH_INCLUDE."get_array_groups.inc.php");
			break;

	}  // end of switch


// unset checkbox if already granted or already revoked
// Only for Grant and Revoke (i.e. username is set)
	if (isset($user)) {
		// $user variable comes from hyperlink (ex. &user=postgres)
		// name may contain a space, so must encode and decode it.
		$username = rawurldecode($user);

		$i = 0;
		while ($p = $arrPrivileges[$i]) {
			if ($user_privilege_array[$username][$p] == $Expected) {
				unset($cb_priv[$p]);
			}
			$i++;
		}
	}


// $web_page is template page that is displayed.
$web_page = webpage($PHP_SELF);

//Display Page
include($PATH_TEMPLATE.$cfgTemplate1);

?>
