<?
/**************************************************
File name:	tbl_properties.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Table Properties.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

session_start();
include ("$PATH_INCLUDE"."pre.inc.php");


// Assign $table and $field
if (!empty($ntable)) { $table = $ntable; }
if (!empty($nfield)) { $field = $nfield; }

# must be after assigning session variables
include ("$PATH_INCLUDE"."links.inc.php");


// Build array of tables
include ($PATH_INCLUDE."get_table_def.inc.php");


// Define DisplaySQL.inc.php Variables
#Hide Columns
$SQL_Column_Show[0] = false;
$SQL_Column_Show[3] = false;
$SQL_Column_Show[4] = false;
$SQL_Column_Show[7] = $cfgShowComments;
#columns 8 - 18 are false in get_table_def.
$SQL_Column_Show[10] = true;
$SQL_Column_Show[11] = true;
$SQL_Column_Show[12] = true;  


#Extra Heading
$numAddExtraColumns = 4;
$Extra_Heading_Value[0] = $strAction;
$Extra_Heading_Show[0] = $cfgShowActions;
$Extra_Heading_Span[0] = 4;


# Extra Columns (Links)
for ($i = 0; $i < $num_rows; $i++) {

	# Change Default to "Display Default"
	$sql_array[$i][6] = $sql_array[$i][9];

	# Change Link
	$Extra_Column_Value[$i][0] = "<a class=link href=tbl_alter.php?ntable=".$table."&nfield=".$sql_array[$i][1]."&gotopage=tbl_properties.php>".$strChange."</a>";

	# Drop Link Link
	$Extra_Column_Value[$i][1] = $strDrop;

	# Index Link
	$cfgIndexColumnSQL = urlencode("CREATE INDEX ".dq($sql_array[$i][1]. "_" . $table . "_key")." ON ".dq($table)."(".dq($sql_array[$i][1]).")");

	$Extra_Column_Value[$i][2] = "<a class=link href=sqlresults.php?sql_query=".$cfgIndexColumnSQL."&gotopage=tbl_properties.php>".$strIndex."</a>";


	# Unique Link
	$cfgUniqueColumnSQL = urlencode("CREATE UNIQUE INDEX ".dq($sql_array[$i][1] . "_" . $table . "_ukey")." ON ".dq($table)."(".dq($sql_array[$i][1]).")");
	$Extra_Column_Value[$i][3] = "<a class=link href=sqlresults.php?sql_query=".$cfgUniqueColumnSQL."&gotopage=tbl_properties.php>".$strUnique."</a>";


	$Extra_Column_Show[$i][0] = $cfgShowActions;
	$Extra_Column_Show[$i][1] = $cfgShowActions;
	$Extra_Column_Show[$i][2] = $cfgShowActions;
	$Extra_Column_Show[$i][3] = $cfgShowActions;

} # end of for loop


// $web_page is template page that is displayed.
$web_page = webpage($PHP_SELF);


//Display Page
include($PATH_TEMPLATE.$cfgTemplate1);


?>

 

