/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.postgresql.pljava.jdbc.SPIConnection;

public abstract class AbstractResultSetMetaData
implements ResultSetMetaData {
    private Connection m_conn = null;

    public abstract int getColumnCount() throws SQLException;

    public abstract boolean isAutoIncrement(int var1) throws SQLException;

    public final boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        switch (this.getOid(n)) {
            case 17: 
            case 25: 
            case 1042: 
            case 1043: {
                return true;
            }
        }
        return false;
    }

    public final boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public final boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return 2;
    }

    public final boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        switch (this.getOid(n)) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: {
                return true;
            }
        }
        return false;
    }

    public final int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        switch (this.getOid(n)) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 20: {
                return 20;
            }
            case 25: {
                return this.getFieldLength(n);
            }
            case 1700: {
                return 20;
            }
            case 700: {
                return 11;
            }
            case 701: {
                return 20;
            }
            case 16: {
                return 3;
            }
            case 1082: {
                return 13;
            }
            case 1083: {
                return 10;
            }
            case 1114: {
                return 25;
            }
            case 1184: {
                return 25;
            }
            case 17: {
                return this.getFieldLength(n);
            }
            case 1043: {
                return this.getFieldLength(n);
            }
            case 26: {
                return 20;
            }
            case 1042: {
                return this.getFieldLength(n);
            }
        }
        return this.getFieldLength(n);
    }

    public abstract String getColumnLabel(int var1) throws SQLException;

    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getColumnLabel(n);
    }

    public final String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        switch (this.getOid(n)) {
            case 21: {
                return 5;
            }
            case 23: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 16;
            }
            case 16: {
                return 1;
            }
            case 26: {
                return 20;
            }
            case 1700: {
                return -1;
            }
        }
        return 0;
    }

    public final int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        switch (this.getOid(n)) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                return 0;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 16;
            }
            case 1700: {
                return -1;
            }
        }
        return 0;
    }

    public final String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return ((SPIConnection)this.getDefaultConnection()).getSQLType(this.getOid(n));
    }

    public final String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return ((SPIConnection)this.getDefaultConnection()).getPGType(this.getOid(n));
    }

    public final boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public final boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public abstract String getColumnClassName(int var1) throws SQLException;

    protected abstract void checkColumnIndex(int var1) throws SQLException;

    protected abstract int getOid(int var1) throws SQLException;

    protected abstract int getFieldLength(int var1) throws SQLException;

    private Connection getDefaultConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = DriverManager.getConnection("jdbc:default:connection");
        }
        return this.m_conn;
    }
}

