/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TransactionalMap
extends HashMap {
    private static final Object s_noObject = new Object();
    private Set m_entrySet;
    private Set m_keySet;
    private Collection m_valueColl;
    private final Map m_base;

    protected TransactionalMap(Map map) {
        this.m_base = map;
    }

    public void abort() {
        super.clear();
    }

    public void clear() {
        super.clear();
        Iterator iterator = this.m_base.keySet().iterator();
        while (iterator.hasNext()) {
            super.put(iterator.next(), s_noObject);
        }
    }

    public void commit() {
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == s_noObject) {
                this.m_base.remove(k);
                continue;
            }
            this.m_base.put(k, v);
        }
        super.clear();
    }

    public boolean containsKey(Object object) {
        Object v = super.get(object);
        if (v != null) {
            return v != s_noObject;
        }
        return super.containsKey(object) || this.m_base.containsKey(object);
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v == s_noObject) {
            v = null;
        } else if (v == null && !super.containsKey(object)) {
            v = this.m_base.get(object);
        }
        return v;
    }

    public Object remove(Object object) {
        Object v = super.get(object);
        if (v == s_noObject) {
            return null;
        }
        Object v2 = this.m_base.get(object);
        if (v2 == null && !this.m_base.containsKey(object)) {
            if (v != null || super.containsKey(object)) {
                super.remove(object);
            }
            return v;
        }
        if (v == null && !super.containsKey(object)) {
            v = v2;
        }
        super.put(object, s_noObject);
        return v;
    }

    public int size() {
        int n = this.m_base.size();
        int n2 = super.size();
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v == s_noObject) {
                --n;
                continue;
            }
            if (this.m_base.containsKey(entry.getKey())) continue;
            ++n;
        }
        return n;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.getValueIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != object && (e == null || !e.equals(object))) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return TransactionalMap.this.getEntryIterator();
                }

                public int size() {
                    return TransactionalMap.this.size();
                }

                public boolean contains(Object object) {
                    return TransactionalMap.this.containsKey(object);
                }
            };
        }
        return this.m_entrySet;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new AbstractSet(){

                public Iterator iterator() {
                    return TransactionalMap.this.getKeyIterator();
                }

                public int size() {
                    return TransactionalMap.this.size();
                }

                public boolean contains(Object object) {
                    return TransactionalMap.this.containsKey(object);
                }
            };
        }
        return this.m_keySet;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(object);
        super.put(object, object2);
        return object3;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Collection values() {
        if (this.m_valueColl == null) {
            this.m_valueColl = new AbstractCollection(){

                public Iterator iterator() {
                    return TransactionalMap.this.getValueIterator();
                }

                public int size() {
                    return TransactionalMap.this.size();
                }

                public boolean contains(Object object) {
                    return TransactionalMap.this.containsValue(object);
                }
            };
        }
        return this.m_valueColl;
    }

    private Set superKeySet() {
        return super.keySet();
    }

    protected Iterator getEntryIterator() {
        return new EntryIterator();
    }

    protected Iterator getKeyIterator() {
        return new KeyIterator();
    }

    protected Iterator getValueIterator() {
        return new ValueIterator();
    }

    static /* synthetic */ Set access$000(TransactionalMap transactionalMap) {
        return transactionalMap.superKeySet();
    }

    protected class ValueIterator
    extends KeyIterator {
        protected ValueIterator() {
        }

        public Object next() {
            return TransactionalMap.this.get(super.next());
        }
    }

    protected class EntryIterator
    extends KeyIterator {
        protected EntryIterator() {
        }

        public Object next() {
            return new BackedEntry(super.next());
        }
    }

    protected class KeyIterator
    implements Iterator {
        private boolean m_phaseA = true;
        private Iterator m_currentItor = TransactionalMap.access$000(TransactionalMap.this).iterator();
        private Object m_currentKey = null;

        protected KeyIterator() {
        }

        public boolean hasNext() {
            this.m_currentKey = this.getValidKey(this.m_currentKey);
            return this.m_currentKey != null;
        }

        public Object next() {
            Object object = this.getValidKey(this.m_currentKey);
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.m_currentKey = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Object getValidKey(Object object) {
            if (object != null && TransactionalMap.this.containsKey(object)) {
                return object;
            }
            while (true) {
                if (this.m_currentItor.hasNext()) {
                    object = this.m_currentItor.next();
                    if (!TransactionalMap.this.containsKey(object)) continue;
                    return object;
                }
                if (!this.m_phaseA) break;
                this.m_currentItor = TransactionalMap.this.m_base.keySet().iterator();
                this.m_phaseA = false;
            }
            return null;
        }
    }

    protected class BackedEntry
    implements Map.Entry {
        private Object m_key;

        public BackedEntry(Object object) {
            this.m_key = object;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return TransactionalMap.this.get(this.m_key);
        }

        public Object setValue(Object object) {
            return TransactionalMap.this.put(this.m_key, object);
        }
    }
}

