/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import org.postgresql.pljava.Session;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.TriggerException;

public class Triggers {
    static void insertUsername(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (triggerData.isFiredByDelete()) {
            throw new TriggerException(triggerData, "can't process DELETE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        if (resultSet.getString(stringArray[0]) == null) {
            resultSet.updateString(stringArray[0], Session.current().getUserName());
        }
    }

    static void afterUsernameUpdate(TriggerData triggerData) throws SQLException {
        Logger logger = Logger.getAnonymousLogger();
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredBefore()) {
            throw new TriggerException(triggerData, "must be fired after event");
        }
        if (!triggerData.isFiredByUpdate()) {
            throw new TriggerException(triggerData, "can't process DELETE or INSERT events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        String string = stringArray[0];
        ResultSet resultSet2 = triggerData.getOld();
        logger.info("Old name is \"" + resultSet2.getString(string) + '\"');
        logger.info("New name is \"" + resultSet.getString(string) + '\"');
    }

    static void moddatetime(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (!triggerData.isFiredByUpdate()) {
            throw new TriggerException(triggerData, "can only process UPDATE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        resultSet.updateTimestamp(stringArray[0], new Timestamp(System.currentTimeMillis()));
    }
}

