/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TransactionalMap
extends HashMap {
    private static final long serialVersionUID = 5337569423915578121L;
    private static final Object s_noObject = new Object();
    private Set m_entrySet;
    private Set m_keySet;
    private Collection m_valueColl;
    private final Map m_base;

    protected TransactionalMap(Map map) {
        this.m_base = map;
    }

    public void abort() {
        super.clear();
    }

    public void clear() {
        super.clear();
        Iterator iterator = this.m_base.keySet().iterator();
        while (iterator.hasNext()) {
            super.put(iterator.next(), s_noObject);
        }
    }

    public void commit() {
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == s_noObject) {
                this.m_base.remove(k);
                continue;
            }
            this.m_base.put(k, v);
        }
        super.clear();
    }

    public boolean containsKey(Object object) {
        Object v = super.get(object);
        if (v != null) {
            return v != s_noObject;
        }
        return super.containsKey(object) || this.m_base.containsKey(object);
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v == s_noObject) {
            v = null;
        } else if (v == null && !super.containsKey(object)) {
            v = this.m_base.get(object);
        }
        return v;
    }

    public Object remove(Object object) {
        Object v = super.get(object);
        if (v == s_noObject) {
            return null;
        }
        Object v2 = this.m_base.get(object);
        if (v2 == null && !this.m_base.containsKey(object)) {
            if (v != null || super.containsKey(object)) {
                super.remove(object);
            }
            return v;
        }
        if (v == null && !super.containsKey(object)) {
            v = v2;
        }
        super.put(object, s_noObject);
        return v;
    }

    public int size() {
        int n = this.m_base.size();
        int n2 = super.size();
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v == s_noObject) {
                --n;
                continue;
            }
            if (this.m_base.containsKey(entry.getKey())) continue;
            ++n;
        }
        return n;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.getValueIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != object && (e == null || !e.equals(object))) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new AbstractSet(this){
                private /* synthetic */ TransactionalMap this$0;
                {
                    this.this$0 = transactionalMap;
                }

                public Iterator iterator() {
                    return this.this$0.getEntryIterator();
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }
            };
        }
        return this.m_entrySet;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new AbstractSet(this){
                private /* synthetic */ TransactionalMap this$0;
                {
                    this.this$0 = transactionalMap;
                }

                public Iterator iterator() {
                    return this.this$0.getKeyIterator();
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }
            };
        }
        return this.m_keySet;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(object);
        super.put(object, object2);
        return object3;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Collection values() {
        if (this.m_valueColl == null) {
            this.m_valueColl = new AbstractCollection(this){
                private /* synthetic */ TransactionalMap this$0;
                {
                    this.this$0 = transactionalMap;
                }

                public Iterator iterator() {
                    return this.this$0.getValueIterator();
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }
            };
        }
        return this.m_valueColl;
    }

    private Set superKeySet() {
        return super.keySet();
    }

    protected Iterator getEntryIterator() {
        return new EntryIterator(this);
    }

    protected Iterator getKeyIterator() {
        return new KeyIterator(this);
    }

    protected Iterator getValueIterator() {
        return new ValueIterator(this);
    }

    protected class ValueIterator
    extends KeyIterator {
        private /* synthetic */ TransactionalMap this$0;

        public Object next() {
            return this.this$0.get(super.next());
        }

        ValueIterator(TransactionalMap transactionalMap) {
            this.this$0 = transactionalMap;
            super(transactionalMap);
        }
    }

    protected class EntryIterator
    extends KeyIterator {
        private /* synthetic */ TransactionalMap this$0;

        public Object next() {
            return new BackedEntry(this.this$0, super.next());
        }

        EntryIterator(TransactionalMap transactionalMap) {
            this.this$0 = transactionalMap;
            super(transactionalMap);
        }
    }

    protected class KeyIterator
    implements Iterator {
        private /* synthetic */ TransactionalMap this$0;
        private boolean m_phaseA;
        private Iterator m_currentItor;
        private Object m_currentKey;

        private /* synthetic */ void finit$() {
            this.m_phaseA = true;
            this.m_currentItor = this.this$0.superKeySet().iterator();
            this.m_currentKey = null;
        }

        public boolean hasNext() {
            this.m_currentKey = this.getValidKey(this.m_currentKey);
            return this.m_currentKey != null;
        }

        public Object next() {
            Object object = this.getValidKey(this.m_currentKey);
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.m_currentKey = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Object getValidKey(Object object) {
            if (object != null && this.this$0.containsKey(object)) {
                return object;
            }
            while (true) {
                if (this.m_currentItor.hasNext()) {
                    object = this.m_currentItor.next();
                    if (!this.this$0.containsKey(object)) continue;
                    return object;
                }
                if (!this.m_phaseA) break;
                this.m_currentItor = this.this$0.m_base.keySet().iterator();
                this.m_phaseA = false;
            }
            return null;
        }

        KeyIterator(TransactionalMap transactionalMap) {
            this.this$0 = transactionalMap;
            this.finit$();
        }
    }

    protected class BackedEntry
    implements Map.Entry {
        private /* synthetic */ TransactionalMap this$0;
        private Object m_key;

        public BackedEntry(TransactionalMap transactionalMap, Object object) {
            this.this$0 = transactionalMap;
            this.m_key = object;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.this$0.get(this.m_key);
        }

        public Object setValue(Object object) {
            return this.this$0.put(this.m_key, object);
        }
    }
}

