/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.management.SQLDeploymentDescriptor;

public class Commands {
    public static void installJar(String string, String string2, boolean bl) throws SQLException {
        SQLException sQLException3;
        Connection connection;
        block13: {
            Commands.assertJarName(string2);
            connection = DriverManager.getConnection("jdbc:default:connection");
            try {
                if (Commands.getJarId(connection, string2) >= 0) {
                    throw new SQLException("A jar named '" + string2 + "' already exists");
                }
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO sqlj.jar_repository(jarName, jarOrigin) VALUES(?, ?)");
                try {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string);
                    if (preparedStatement.executeUpdate() != 1) {
                        throw new SQLException("Jar repository insert did not insert 1 row");
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException3) {}
                int n = Commands.getJarId(connection, string2);
                if (n < 0) {
                    throw new SQLException("Unable to obtain id of '" + string2 + "'");
                }
                Commands.addClassImages(connection, n, string);
                if (!bl) break block13;
                Commands.deployInstall(connection, n);
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    connection.close();
                }
                catch (SQLException sQLException4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Object var5_8 = null;
        try {
            connection.close();
        }
        catch (SQLException sQLException3) {}
    }

    public static void replaceJar(String string, String string2, boolean bl) throws SQLException {
        SQLException sQLException3;
        Object var6_6;
        Connection connection;
        block20: {
            connection = DriverManager.getConnection("jdbc:default:connection");
            try {
                int n = Commands.getJarId(connection, string2);
                if (n < 0) {
                    throw new SQLException("No Jar named '" + string2 + "' is known to the system");
                }
                if (bl) {
                    Commands.deployRemove(connection, n);
                }
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE sqlj.jar_repository SET jarOrigin = ?, deploymentDesc = NULL WHERE jarId = ?");
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    if (preparedStatement.executeUpdate() != 1) {
                        throw new SQLException("Jar repository update did not update 1 row");
                    }
                    var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException3) {}
                preparedStatement = connection.prepareStatement("DELETE FROM sqlj.jar_entry WHERE jarId = ?");
                try {
                    preparedStatement.setInt(1, n);
                    preparedStatement.executeUpdate();
                }
                finally {
                    var6_6 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException3) {}
                }
                Commands.addClassImages(connection, n, string);
                if (!bl) break block20;
                Commands.deployInstall(connection, n);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    connection.close();
                }
                catch (SQLException sQLException4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        var6_6 = null;
        try {
            connection.close();
        }
        catch (SQLException sQLException3) {}
    }

    public static void removeJar(String string, boolean bl) throws SQLException {
        SQLException sQLException3;
        Commands.assertJarName(string);
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            Object var5_5;
            int n = Commands.getJarId(connection, string);
            if (n < 0) {
                throw new SQLException("No Jar named '" + string + "' is known to the system");
            }
            if (bl) {
                Commands.deployRemove(connection, n);
            }
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM sqlj.jar_repository WHERE jarId = ?");
            try {
                preparedStatement.setInt(1, n);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Jar repository update did not update 1 row");
                }
                var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException3) {}
            var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                connection.close();
            }
            catch (SQLException sQLException4) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException3) {}
    }

    public static void setClassPath(String string, String string2) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            Object var5_6;
            PreparedStatement preparedStatement;
            string = string == null || string.length() == 0 ? "public" : string.toLowerCase();
            if (Commands.getSchemaId(connection, string) == null) {
                throw new SQLException("No such schema: " + string);
            }
            ArrayList<Integer> arrayList = null;
            if (string2 != null && string2.length() > 0) {
                arrayList = new ArrayList<Integer>();
                preparedStatement = connection.prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
                try {
                    int n;
                    do {
                        String string3;
                        if ((n = string2.indexOf(58)) >= 0) {
                            string3 = string2.substring(0, n);
                            string2 = string2.substring(n + 1);
                        } else {
                            string3 = string2;
                        }
                        int n2 = Commands.getJarId(preparedStatement, string3);
                        if (n2 < 0) {
                            throw new SQLException("No such jar: " + string3);
                        }
                        arrayList.add(new Integer(n2));
                    } while (n >= 0);
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            preparedStatement = connection.prepareStatement("DELETE FROM sqlj.classpath_entry WHERE schemaName = ?");
            try {
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
            }
            finally {
                var5_6 = null;
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (arrayList != null) {
                preparedStatement = connection.prepareStatement("INSERT INTO sqlj.classpath_entry(schemaName, ordinal, jarId) VALUES(?, ?, ?)");
                try {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        int n3 = (Integer)arrayList.get(i);
                        preparedStatement.setString(1, string);
                        preparedStatement.setInt(2, i + 1);
                        preparedStatement.setInt(3, n3);
                        preparedStatement.executeUpdate();
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassPath(String var0) throws SQLException {
        block27: {
            block26: {
                var1_1 = DriverManager.getConnection("jdbc:default:connection");
                try {
                    block25: {
                        block29: {
                            block24: {
                                var0 = var0 == null || var0.length() == 0 ? "public" : var0.toLowerCase();
                                var2_2 = var1_1.prepareStatement("SELECT r.jarName FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal");
                                try {
                                    block23: {
                                        block28: {
                                            block22: {
                                                var2_2.setString(1, var0);
                                                var3_3 = var2_2.executeQuery();
                                                try {
                                                    var4_4 = null;
                                                    while (var3_3.next()) {
                                                        if (var4_4 == null) {
                                                            var4_4 = new StringBuffer();
                                                        } else {
                                                            var4_4.append(':');
                                                        }
                                                        var4_4.append(var3_3.getString(1));
                                                    }
                                                    if (var4_4 == null) {
                                                        var5_5 = null;
                                                        var6_7 = null;
                                                        break block22;
                                                    }
                                                    var5_6 = var4_4.toString();
                                                    break block23;
                                                }
                                                catch (Throwable var7_17) {
                                                    var6_9 = null;
                                                    try {
                                                        var3_3.close();
                                                        throw var7_17;
                                                    }
                                                    catch (SQLException var8_14) {
                                                        // empty catch block
                                                    }
                                                    throw var7_17;
                                                }
                                            }
                                            ** try [egrp 3[TRYBLOCK] [1 : 157->166)] { 
lbl38:
                                            // 1 sources

                                            var3_3.close();
                                            break block28;
lbl40:
                                            // 1 sources

                                            catch (SQLException var8_12) {
                                            }
                                        }
                                        var6_7 = null;
                                        break block24;
                                    }
                                    var6_8 = null;
                                    try {}
                                    catch (SQLException var8_13) {
                                        break block25;
                                    }
                                    var3_3.close();
                                    break block25;
                                }
                                catch (Throwable var7_18) {
                                    var6_10 = null;
                                    try {
                                        var2_2.close();
                                        throw var7_18;
                                    }
                                    catch (SQLException var8_15) {
                                        // empty catch block
                                    }
                                    throw var7_18;
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [3 : 180->189)] { 
lbl64:
                            // 1 sources

                            var2_2.close();
                            break block29;
lbl66:
                            // 1 sources

                            catch (SQLException var8_12) {
                            }
                        }
                        var6_7 = null;
                        break block26;
                    }
                    var6_8 = null;
                    try {}
                    catch (SQLException var8_13) {
                        break block27;
                    }
                    var2_2.close();
                    break block27;
                }
                catch (Throwable var7_19) {
                    var6_11 = null;
                    try {
                        var1_1.close();
                        throw var7_19;
                    }
                    catch (SQLException var8_16) {
                        throw var7_19;
                    }
                }
            }
            ** try [egrp 5[TRYBLOCK] [5 : 203->212)] { 
lbl89:
            // 1 sources

            var1_1.close();
            return var5_5;
lbl91:
            // 1 sources

            catch (SQLException var8_12) {
                // empty catch block
            }
            return var5_5;
        }
        var6_8 = null;
        ** try [egrp 5[TRYBLOCK] [5 : 203->212)] { 
lbl97:
        // 1 sources

        var1_1.close();
        return var5_6;
lbl99:
        // 1 sources

        catch (SQLException var8_13) {
            // empty catch block
        }
        return var5_6;
    }

    protected static void addClassImages(Connection connection, int n, String string) throws SQLException {
        Object object;
        ResultSet resultSet;
        Statement statement;
        Statement statement2;
        block30: {
            InputStream inputStream = null;
            statement2 = null;
            statement = null;
            resultSet = null;
            try {
                try {
                    JarEntry jarEntry;
                    int n2 = -1;
                    URL uRL = new URL(string);
                    inputStream = uRL.openStream();
                    object = new byte[1024];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    statement2 = connection.prepareStatement("INSERT INTO sqlj.jar_entry(entryName, jarId, entryImage) VALUES(?, ?, ?)");
                    JarInputStream jarInputStream = new JarInputStream(inputStream);
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        int n3;
                        if (jarEntry.isDirectory()) continue;
                        String string2 = jarEntry.getName();
                        Attributes attributes = jarEntry.getAttributes();
                        boolean bl = false;
                        if (attributes != null && (bl = "true".equalsIgnoreCase(attributes.getValue("SQLJDeploymentDescriptor"))) && n2 >= 0) {
                            throw new SQLException("Only one SQLJDeploymentDescriptor allowed");
                        }
                        byteArrayOutputStream.reset();
                        while ((n3 = jarInputStream.read((byte[])object)) > 0) {
                            byteArrayOutputStream.write((byte[])object, 0, n3);
                        }
                        jarInputStream.closeEntry();
                        statement2.setString(1, string2);
                        statement2.setInt(2, n);
                        statement2.setBytes(3, byteArrayOutputStream.toByteArray());
                        if (statement2.executeUpdate() != 1) {
                            throw new SQLException("Jar entry insert did not insert 1 row");
                        }
                        if (!bl) continue;
                        statement = connection.prepareStatement("SELECT entryId FROM sqlj.jar_entry WHERE jarId = ? AND entryName = ?");
                        statement.setInt(1, n);
                        statement.setString(2, string2);
                        resultSet = statement.executeQuery();
                        if (!resultSet.next()) {
                            throw new SQLException("Failed to refecth row in sqlj.jar_entry");
                        }
                        n2 = resultSet.getInt(1);
                    }
                    if (n2 >= 0) {
                        statement2.close();
                        statement2 = connection.prepareStatement("UPDATE sqlj.jar_repository SET deploymentDesc = ? WHERE jarId = ?");
                        statement2.setInt(1, n2);
                        statement2.setInt(2, n);
                        if (statement2.executeUpdate() != 1) {
                            throw new SQLException("Jar repository update did not insert 1 row");
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new SQLException("I/O exception reading jar file: " + iOException.getMessage());
                }
                Object var7_9 = null;
                if (inputStream == null) break block30;
            }
            catch (Throwable throwable) {
                Exception exception2;
                Object var7_10 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException exception2) {
                        // empty catch block
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException exception2) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException exception2) {
                        // empty catch block
                    }
                }
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (SQLException exception2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                object = iOException;
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                object = sQLException;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                object = sQLException;
            }
        }
        if (statement2 != null) {
            try {
                statement2.close();
            }
            catch (SQLException sQLException) {
                object = sQLException;
            }
        }
    }

    protected static void deployInstall(Connection connection, int n) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(connection, n);
        if (sQLDeploymentDescriptor != null) {
            sQLDeploymentDescriptor.install(connection);
        }
    }

    protected static void deployRemove(Connection connection, int n) throws SQLException {
        SQLDeploymentDescriptor sQLDeploymentDescriptor = Commands.getDeploymentDescriptor(connection, n);
        if (sQLDeploymentDescriptor != null) {
            sQLDeploymentDescriptor.remove(connection);
        }
    }

    protected static void assertJarName(String string) throws SQLException {
        int n;
        if (string != null && (n = string.length()) > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
            int n2;
            for (n2 = 1; n2 < n && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
            }
            if (n2 == n) {
                return;
            }
        }
        throw new SQLException("The jar name '" + string + "' is not a valid name");
    }

    protected static int getJarId(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT jarId FROM sqlj.jar_repository WHERE jarName = ?");
        try {
            n = Commands.getJarId(preparedStatement, string);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n;
    }

    /*
     * Loose catch block
     */
    protected static int getJarId(PreparedStatement preparedStatement, String string) throws SQLException {
        int n;
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) break block6;
        int n2 = -1;
        Object var4_5 = null;
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        {
            block6: {
                return n2;
            }
            n = resultSet.getInt(1);
        }
        Object var4_6 = null;
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n;
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static SQLDeploymentDescriptor getDeploymentDescriptor(Connection var0, int var1_1) throws SQLException {
        block24: {
            block23: {
                block22: {
                    var2_2 = var0.prepareStatement("SELECT e.entryImage FROM sqlj.jar_repository r INNER JOIN sqlj.jar_entry e   ON r.deploymentDesc = e.entryId WHERE r.jarId = ?");
                    try {
                        block21: {
                            block20: {
                                block25: {
                                    block19: {
                                        var2_2.setInt(1, var1_1);
                                        var3_3 = var2_2.executeQuery();
                                        try {
                                            try {
                                                if (!var3_3.next()) {
                                                    var4_4 = null;
                                                    var6_7 = null;
                                                    break block19;
                                                }
                                                var5_19 = var3_3.getBytes(1);
                                                if (var5_19.length == 0) {
                                                    var4_5 = null;
                                                    break block20;
                                                }
                                                var4_6 = new SQLDeploymentDescriptor(new String(var5_19, "UTF8"), "postgresql");
                                                break block21;
                                            }
                                            catch (UnsupportedEncodingException var6_10) {
                                                throw new SQLException("JVM does not support UTF8!!");
                                            }
                                            catch (ParseException var6_11) {
                                                throw new SQLException(var6_11.getMessage() + " at " + var6_11.getErrorOffset());
                                            }
                                        }
                                        catch (Throwable var7_20) {
                                            var6_12 = null;
                                            try {
                                                var3_3.close();
                                                throw var7_20;
                                            }
                                            catch (SQLException var8_17) {
                                                // empty catch block
                                            }
                                            throw var7_20;
                                        }
                                    }
                                    ** try [egrp 3[TRYBLOCK] [3 : 171->180)] { 
lbl35:
                                    // 1 sources

                                    var3_3.close();
                                    break block25;
lbl37:
                                    // 1 sources

                                    catch (SQLException var8_14) {
                                    }
                                }
                                var6_7 = null;
                                break block22;
                            }
                            var6_8 = null;
                            try {}
                            catch (SQLException var8_15) {
                                break block23;
                            }
                            var3_3.close();
                            break block23;
                        }
                        var6_9 = null;
                        try {}
                        catch (SQLException var8_16) {
                            break block24;
                        }
                        var3_3.close();
                        break block24;
                    }
                    catch (Throwable var7_21) {
                        var6_13 = null;
                        try {
                            var2_2.close();
                            throw var7_21;
                        }
                        catch (SQLException var8_18) {
                            throw var7_21;
                        }
                    }
                }
                ** try [egrp 4[TRYBLOCK] [5 : 194->203)] { 
lbl68:
                // 1 sources

                var2_2.close();
                return var4_4;
lbl70:
                // 1 sources

                catch (SQLException var8_14) {
                    // empty catch block
                }
                return var4_4;
            }
            var6_8 = null;
            ** try [egrp 4[TRYBLOCK] [5 : 194->203)] { 
lbl76:
            // 1 sources

            var2_2.close();
            return var4_5;
lbl78:
            // 1 sources

            catch (SQLException var8_15) {
                // empty catch block
            }
            return var4_5;
        }
        var6_9 = null;
        ** try [egrp 4[TRYBLOCK] [5 : 194->203)] { 
lbl84:
        // 1 sources

        var2_2.close();
        return var4_6;
lbl86:
        // 1 sources

        catch (SQLException var8_16) {
            // empty catch block
        }
        return var4_6;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Oid getSchemaId(Connection var0, String var1_1) throws SQLException {
        block16: {
            block15: {
                var2_2 = var0.prepareStatement("SELECT oid FROM pg_namespace WHERE nspname = ?");
                try {
                    block14: {
                        block17: {
                            block13: {
                                var2_2.setString(1, var1_1);
                                var3_3 = var2_2.executeQuery();
                                try {
                                    if (!var3_3.next()) {
                                        var4_4 = null;
                                        var5_6 = null;
                                        break block13;
                                    }
                                    var4_5 = (Oid)var3_3.getObject(1);
                                    break block14;
                                }
                                catch (Throwable var6_14) {
                                    var5_8 = null;
                                    try {
                                        var3_3.close();
                                        throw var6_14;
                                    }
                                    catch (SQLException var7_12) {
                                        // empty catch block
                                    }
                                    throw var6_14;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [1 : 77->86)] { 
lbl25:
                            // 1 sources

                            var3_3.close();
                            break block17;
lbl27:
                            // 1 sources

                            catch (SQLException var7_10) {
                            }
                        }
                        var5_6 = null;
                        break block15;
                    }
                    var5_7 = null;
                    try {}
                    catch (SQLException var7_11) {
                        break block16;
                    }
                    var3_3.close();
                    break block16;
                }
                catch (Throwable var6_15) {
                    var5_9 = null;
                    try {
                        var2_2.close();
                        throw var6_15;
                    }
                    catch (SQLException var7_13) {
                        throw var6_15;
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 100->109)] { 
lbl50:
            // 1 sources

            var2_2.close();
            return var4_4;
lbl52:
            // 1 sources

            catch (SQLException var7_10) {
                // empty catch block
            }
            return var4_4;
        }
        var5_7 = null;
        ** try [egrp 3[TRYBLOCK] [3 : 100->109)] { 
lbl58:
        // 1 sources

        var2_2.close();
        return var4_5;
lbl60:
        // 1 sources

        catch (SQLException var7_11) {
            // empty catch block
        }
        return var4_5;
    }
}

